/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.options;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.mapton.core.ui.options.MainPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public final class MainOptionsPanelController
extends OptionsPanelController {
    private boolean mChanged;
    private MainPanel mMainPanel;
    private final PropertyChangeSupport mPropertyChangeSupport = new PropertyChangeSupport((Object)this);

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.mPropertyChangeSupport.addPropertyChangeListener(l);
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(() -> {
            this.getMainPanel().store();
            this.mChanged = false;
        });
    }

    public void cancel() {
        this.mMainPanel.cancel();
    }

    public JComponent getComponent(Lookup masterLookup) {
        return this.getMainPanel();
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isChanged() {
        return this.mChanged;
    }

    public boolean isValid() {
        return this.getMainPanel().valid();
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.mPropertyChangeSupport.removePropertyChangeListener(l);
    }

    public void update() {
        this.getMainPanel().load();
        this.mChanged = false;
    }

    void changed() {
        if (!this.mChanged) {
            this.mChanged = true;
            this.mPropertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.mPropertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private MainPanel getMainPanel() {
        if (this.mMainPanel == null) {
            this.mMainPanel = new MainPanel(this);
        }
        return this.mMainPanel;
    }
}

