/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.controlsfx.control.ToggleSwitch;
import org.mapton.api.MDict;
import org.mapton.api.MEngine;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.MOptions;
import org.mapton.api.Mapton;
import org.mapton.core.ui.options.MainOptionsPanelController;
import org.openide.LifecycleManager;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import se.trixon.almond.nbp.fx.FxPanel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.fx.FxHelper;

final class MainPanel
extends JPanel {
    private final ResourceBundle mBundle;
    private final MainOptionsPanelController mController;
    private ToggleSwitch mCrosshairToggleSwitch;
    private ComboBox<String> mEngineComboBox;
    private final FxPanel mFxPanel;
    private ToggleSwitch mHomeIconToggleSwitch;
    private ColorPicker mIconBrightColorPicker;
    private ColorPicker mIconDarkColorPicker;
    private ToggleSwitch mNightModeToggleSwitch;
    private boolean mOldDisplayCrosshair;
    private boolean mOldDisplayHomeIcon;
    private String mOldEngine;
    private Color mOldIconColorBright;
    private Color mOldIconColorDark;
    private boolean mOldNightMode;
    private boolean mOldPopover;
    private final MOptions mOptions = MOptions.getInstance();
    private ToggleSwitch mPopoverToggleSwitch;

    MainPanel(MainOptionsPanelController controller) {
        this.mBundle = NbBundle.getBundle(MOptions.class);
        this.mController = controller;
        this.mFxPanel = new FxPanel(){

            @Override
            protected void fxConstructor() {
                this.setScene(this.createScene());
                this.initListeners();
                MainPanel.this.populateEngines();
            }

            private Scene createScene() {
                Label lafSectionLabel = new Label(Dict.LOOK_AND_FEEL.toString());
                Label mapSectionLabel = new Label(Dict.MAP.toString());
                lafSectionLabel.setPadding(FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)6.0, (double)0.0));
                mapSectionLabel.setPadding(FxHelper.getUIScaledInsets((double)12.0, (double)0.0, (double)6.0, (double)0.0));
                Font sectionFont = Font.font((double)(Font.getDefault().getSize() * 1.5));
                lafSectionLabel.setFont(sectionFont);
                mapSectionLabel.setFont(sectionFont);
                int row = 0;
                GridPane gp = new GridPane();
                gp.addRow(row++, new Node[]{lafSectionLabel});
                Label popoverLabel = new Label(MainPanel.this.mBundle.getString("popover"));
                Label nightModeLabel = new Label(Dict.NIGHT_MODE.toString());
                Label iconColorLabel = new Label(MainPanel.this.mBundle.getString("iconColor"));
                Label iconColorNightModeLabel = new Label(MainPanel.this.mBundle.getString("iconColorNightMode"));
                int n = row++;
                Node[] nodeArray = new Node[2];
                nodeArray[0] = popoverLabel;
                MainPanel.this.mPopoverToggleSwitch = new ToggleSwitch();
                nodeArray[1] = MainPanel.this.mPopoverToggleSwitch;
                gp.addRow(n, nodeArray);
                int n2 = row++;
                Node[] nodeArray2 = new Node[2];
                nodeArray2[0] = nightModeLabel;
                MainPanel.this.mNightModeToggleSwitch = new ToggleSwitch();
                nodeArray2[1] = MainPanel.this.mNightModeToggleSwitch;
                gp.addRow(n2, nodeArray2);
                int n3 = row++;
                Node[] nodeArray3 = new Node[2];
                nodeArray3[0] = iconColorLabel;
                MainPanel.this.mIconDarkColorPicker = new ColorPicker();
                nodeArray3[1] = MainPanel.this.mIconDarkColorPicker;
                gp.addRow(n3, nodeArray3);
                int n4 = row++;
                Node[] nodeArray4 = new Node[2];
                nodeArray4[0] = iconColorNightModeLabel;
                MainPanel.this.mIconBrightColorPicker = new ColorPicker();
                nodeArray4[1] = MainPanel.this.mIconBrightColorPicker;
                gp.addRow(n4, nodeArray4);
                Label mapEngineLabel = new Label(MDict.MAP_ENGINE.toString());
                Label crosshairLabel = new Label(MainPanel.this.mBundle.getString("crosshair"));
                Label homeIconLabel = new Label(MainPanel.this.mBundle.getString("homeIcon"));
                gp.addRow(row++, new Node[]{mapSectionLabel});
                int n5 = row++;
                Node[] nodeArray5 = new Node[2];
                nodeArray5[0] = mapEngineLabel;
                MainPanel.this.mEngineComboBox = new ComboBox();
                nodeArray5[1] = MainPanel.this.mEngineComboBox;
                gp.addRow(n5, nodeArray5);
                int n6 = row++;
                Node[] nodeArray6 = new Node[2];
                nodeArray6[0] = crosshairLabel;
                MainPanel.this.mCrosshairToggleSwitch = new ToggleSwitch();
                nodeArray6[1] = MainPanel.this.mCrosshairToggleSwitch;
                gp.addRow(n6, nodeArray6);
                int n7 = row++;
                Node[] nodeArray7 = new Node[2];
                nodeArray7[0] = homeIconLabel;
                MainPanel.this.mHomeIconToggleSwitch = new ToggleSwitch();
                nodeArray7[1] = MainPanel.this.mHomeIconToggleSwitch;
                gp.addRow(n7, nodeArray7);
                GridPane.setColumnSpan((Node)lafSectionLabel, (Integer)Integer.MAX_VALUE);
                GridPane.setColumnSpan((Node)mapSectionLabel, (Integer)Integer.MAX_VALUE);
                gp.setPadding(FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)16.0));
                FxHelper.setPadding((Insets)FxHelper.getUIScaledInsets((double)0.0, (double)0.0, (double)0.0, (double)20.0), (Region[])new Region[]{popoverLabel, nightModeLabel, iconColorLabel, iconColorNightModeLabel, mapEngineLabel, crosshairLabel, homeIconLabel});
                FxHelper.setPadding((Insets)FxHelper.getUIScaledInsets((double)4.0, (double)0.0, (double)4.0, (double)0.0), (Region[])new Region[]{MainPanel.this.mPopoverToggleSwitch, MainPanel.this.mNightModeToggleSwitch, MainPanel.this.mCrosshairToggleSwitch, MainPanel.this.mHomeIconToggleSwitch});
                FxHelper.setMargin((Insets)FxHelper.getUIScaledInsets((double)4.0, (double)0.0, (double)4.0, (double)16.0), (Region[])new Region[]{MainPanel.this.mIconDarkColorPicker, MainPanel.this.mIconBrightColorPicker, MainPanel.this.mEngineComboBox});
                MainPanel.this.mPopoverToggleSwitch.selectedProperty().bindBidirectional((Property)MainPanel.this.mOptions.preferPopoverProperty());
                MainPanel.this.mNightModeToggleSwitch.selectedProperty().bindBidirectional((Property)MainPanel.this.mOptions.nightModeProperty());
                MainPanel.this.mIconBrightColorPicker.valueProperty().bindBidirectional((Property)MainPanel.this.mOptions.iconColorBrightProperty());
                MainPanel.this.mIconDarkColorPicker.valueProperty().bindBidirectional((Property)MainPanel.this.mOptions.iconColorDarkProperty());
                MainPanel.this.mEngineComboBox.valueProperty().bindBidirectional((Property)MainPanel.this.mOptions.engineInternalProperty());
                MainPanel.this.mCrosshairToggleSwitch.selectedProperty().bindBidirectional((Property)MainPanel.this.mOptions.displayCrosshairProperty());
                MainPanel.this.mHomeIconToggleSwitch.selectedProperty().bindBidirectional((Property)MainPanel.this.mOptions.displayHomeIconProperty());
                ScrollPane scrollPane = new ScrollPane((Node)gp);
                return new Scene((Parent)gp);
            }

            private void initListeners() {
                ChangeListener changeListener = (observable, oldValue, newValue) -> MainPanel.this.mController.changed();
                MainPanel.this.mPopoverToggleSwitch.selectedProperty().addListener(changeListener);
                MainPanel.this.mNightModeToggleSwitch.selectedProperty().addListener(changeListener);
                MainPanel.this.mCrosshairToggleSwitch.selectedProperty().addListener(changeListener);
                MainPanel.this.mHomeIconToggleSwitch.selectedProperty().addListener(changeListener);
                MainPanel.this.mEngineComboBox.valueProperty().addListener(changeListener);
                MainPanel.this.mIconBrightColorPicker.valueProperty().addListener(changeListener);
                MainPanel.this.mIconDarkColorPicker.valueProperty().addListener(changeListener);
                Lookup.getDefault().lookupResult(MEngine.class).addLookupListener(ev -> MainPanel.this.populateEngines());
            }
        };
        this.mFxPanel.initFx(null);
        this.mFxPanel.setPreferredSize(null);
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.mFxPanel), "Center");
    }

    void cancel() {
        Platform.runLater(() -> {
            this.mOptions.preferPopoverProperty().set(this.mOldPopover);
            this.mOptions.nightModeProperty().set(this.mOldNightMode);
            this.mOptions.iconColorBrightProperty().set((Object)this.mOldIconColorBright);
            this.mOptions.iconColorDarkProperty().set((Object)this.mOldIconColorDark);
            this.mOptions.displayCrosshairProperty().set(this.mOldDisplayCrosshair);
            this.mOptions.displayHomeIconProperty().set(this.mOldDisplayHomeIcon);
            this.mOptions.engineInternalProperty().set((Object)this.mOldEngine);
        });
    }

    void load() {
        Platform.runLater(() -> this.loadFX());
    }

    void store() {
        Platform.runLater(() -> this.storeFX());
    }

    boolean valid() {
        return true;
    }

    private void loadFX() {
        this.mOldPopover = this.mOptions.isPreferPopover();
        this.mOldNightMode = this.mOptions.isNightMode();
        this.mOldDisplayHomeIcon = this.mOptions.isDisplayHomeIcon();
        this.mOldDisplayCrosshair = this.mOptions.isDisplayCrosshair();
        this.mOldEngine = this.mOptions.getEngine();
        this.mOldIconColorBright = this.mOptions.getIconColorBright();
        this.mOldIconColorDark = this.mOptions.getIconColorDark();
    }

    private void populateEngines() {
        List engines = Lookup.getDefault().lookupAll(MEngine.class).stream().sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).map(MEngine::getName).collect(Collectors.toList());
        this.mEngineComboBox.setItems(FXCollections.observableArrayList(engines));
        this.mEngineComboBox.getSelectionModel().select((Object)Mapton.getEngine().getName());
    }

    private void storeFX() {
        boolean newIconColorDark;
        boolean newNightMode = this.mOptions.isNightMode();
        boolean newIconColorBright = newNightMode && !this.mOldIconColorBright.equals((Object)this.mOptions.getIconColorBright());
        boolean bl = newIconColorDark = !newNightMode && !this.mOldIconColorDark.equals((Object)this.mOptions.getIconColorDark());
        if (this.mOldNightMode != newNightMode || newIconColorBright || newIconColorDark || !this.mOptions.getEngine().equalsIgnoreCase(this.mOldEngine)) {
            String laf = newNightMode ? "com.formdev.flatlaf.FlatDarkLaf" : "com.formdev.flatlaf.FlatLightLaf";
            NbPreferences.root().node("laf").put("laf", laf);
            NotificationDisplayer.getDefault().notify(this.mBundle.getString("restartRequired"), (Icon)MNotificationIcons.getWarningIcon(), Dict.RESTART.toString(), actionEvent -> {
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            }, NotificationDisplayer.Priority.HIGH);
        }
    }
}

