/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.poi;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.cell.CheckBoxTreeCell;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.CheckTreeView;
import org.mapton.api.MPoi;
import org.mapton.api.MPoiManager;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.fx.DelayedResetRunner;

public class PoiCategoryCheckTreeView
extends CheckTreeView<MPoi> {
    private ListChangeListener<TreeItem<MPoi>> mCheckedItemsChangeListener;
    private final DelayedResetRunner mDelayedResetRunner;
    private final Preferences mExpandedPreferences;
    private final MPoiManager mManager = MPoiManager.getInstance();
    private final Map<String, CheckBoxTreeItem<MPoi>> mPoiParents;
    private final Map<TreeItem<MPoi>, TreeItem<MPoi>> mPoisToRemove;
    private CheckBoxTreeItem<MPoi> mRootItem;
    private final HashSet<CheckBoxTreeItem<MPoi>> mTreeItemExpanderSet;
    private final HashSet<CheckBoxTreeItem<MPoi>> mTreeItemListenerSet;
    private final Preferences mVisibilityPreferences = NbPreferences.forModule(PoiCategoryCheckTreeView.class).node("poi_visibility");

    public PoiCategoryCheckTreeView() {
        this.mExpandedPreferences = NbPreferences.forModule(PoiCategoryCheckTreeView.class).node("poi_expanded");
        this.mPoiParents = Collections.synchronizedMap(new TreeMap());
        this.mPoisToRemove = Collections.synchronizedMap(new HashMap());
        this.mTreeItemListenerSet = new HashSet();
        this.mTreeItemExpanderSet = new HashSet();
        this.mDelayedResetRunner = new DelayedResetRunner(50, () -> {
            TreeSet categories = new TreeSet();
            this.getCheckModel().getCheckedItems().forEach(checkedItem -> categories.add(this.getPath((MPoi)checkedItem.getValue())));
            this.mManager.categoriesProperty().set(new TreeSet());
            this.mManager.categoriesProperty().set(categories);
        });
        this.createUI();
        this.initListeners();
    }

    private void createUI() {
        this.mRootItem = new CheckBoxTreeItem((Object)new MPoi());
        this.setRoot((TreeItem)this.mRootItem);
        this.setShowRoot(false);
        this.setCellFactory(treeView -> new PoiTreeCell());
    }

    private String getCategory(MPoi poi) {
        return "%s/%s".formatted(StringUtils.defaultString((String)poi.getProvider()), StringUtils.defaultString((String)poi.getCategory()));
    }

    private CheckBoxTreeItem<MPoi> getParent(CheckBoxTreeItem<MPoi> parent, String category, MPoi poi) {
        String[] categorySegments = StringUtils.split((String)category, (String)"/");
        StringBuilder sb = new StringBuilder();
        for (String segment : categorySegments) {
            sb.append(segment);
            String path = sb.toString();
            if (this.mPoiParents.containsKey(path)) {
                parent = this.mPoiParents.get(path);
            } else {
                MPoi parentPoi = new MPoi();
                parentPoi.setName(segment);
                parentPoi.setProvider(poi.getProvider());
                parentPoi.setCategory(path);
                ObservableList observableList = parent.getChildren();
                parent = this.mPoiParents.computeIfAbsent(sb.toString(), k -> new CheckBoxTreeItem((Object)parentPoi));
                observableList.add((Object)parent);
            }
            sb.append("/");
        }
        return parent;
    }

    private String getPath(MPoi poi) {
        return StringUtils.defaultString((String)poi.getCategory(), (String)"DEFAULT");
    }

    private void initListeners() {
        this.mCheckedItemsChangeListener = c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(treeItem -> {
                        if (!this.isCategoryTreeItem((TreeItem<MPoi>)treeItem)) {
                            this.mVisibilityPreferences.putBoolean(this.getPath((MPoi)treeItem.getValue()), true);
                        }
                    });
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(treeItem -> {
                    if (!this.isCategoryTreeItem((TreeItem<MPoi>)treeItem)) {
                        this.mVisibilityPreferences.putBoolean(this.getPath((MPoi)treeItem.getValue()), false);
                    }
                });
            }
            this.mDelayedResetRunner.reset();
        };
        this.mManager.trigRefreshCategoriesProperty().addListener((observable, oldValue, newValue) -> {
            this.getCheckModel().getCheckedItems().removeListener(this.mCheckedItemsChangeListener);
            this.populate();
            this.getCheckModel().getCheckedItems().addListener(this.mCheckedItemsChangeListener);
        });
    }

    private boolean isCategoryTreeItem(TreeItem<MPoi> treeItem) {
        return !treeItem.getChildren().isEmpty();
    }

    private void populate() {
        this.mRootItem.getChildren().clear();
        this.mTreeItemListenerSet.clear();
        this.mPoisToRemove.clear();
        this.mPoiParents.clear();
        TreeMap<String, CheckBoxTreeItem> poiParents = new TreeMap<String, CheckBoxTreeItem>();
        for (MPoi poi : this.mManager.getAllItems()) {
            CheckBoxTreeItem poiTreeItem = new CheckBoxTreeItem((Object)poi);
            String category = this.getCategory(poi);
            CheckBoxTreeItem parent = poiParents.computeIfAbsent(category, k -> this.getParent(this.mRootItem, category, poi));
            parent.getChildren().add((Object)poiTreeItem);
        }
        this.mPoiParents.clear();
        this.mPoiParents.putAll(poiParents);
        this.postPopulate(this.mRootItem);
        for (Map.Entry<TreeItem<MPoi>, TreeItem<MPoi>> entry : this.mPoisToRemove.entrySet()) {
            try {
                entry.getValue().getChildren().remove(entry.getKey());
            }
            catch (Exception exception) {}
        }
        this.mTreeItemExpanderSet.forEach(checkBoxTreeItem -> checkBoxTreeItem.setExpanded(true));
        this.getCheckModel().clearChecks();
        this.postPopulateRestoreSelection(this.mRootItem);
        this.mDelayedResetRunner.reset();
    }

    private void postPopulate(CheckBoxTreeItem<MPoi> treeItem) {
        MPoi poi = (MPoi)treeItem.getValue();
        if (this.isCategoryTreeItem((TreeItem<MPoi>)treeItem)) {
            String path = this.getPath(poi);
            if (this.mExpandedPreferences.getBoolean(path, false)) {
                this.mTreeItemExpanderSet.add(treeItem);
            }
            if (!this.mTreeItemListenerSet.contains(treeItem)) {
                treeItem.expandedProperty().addListener((observable, oldValue, newValue) -> this.mExpandedPreferences.putBoolean(path, (boolean)newValue));
                this.mTreeItemListenerSet.add(treeItem);
            }
            Comparator c1 = (o1, o2) -> {
                String s1 = ((MPoi)o1.getValue()).getName().toLowerCase(Locale.getDefault());
                String s2 = ((MPoi)o2.getValue()).getName().toLowerCase(Locale.getDefault());
                return s1.compareToIgnoreCase(s2);
            };
            treeItem.getChildren().sort(c1);
            for (TreeItem childTreeItem : treeItem.getChildren()) {
                this.postPopulate((CheckBoxTreeItem<MPoi>)((CheckBoxTreeItem)childTreeItem));
            }
        } else {
            this.mPoisToRemove.put((TreeItem<MPoi>)treeItem, (TreeItem<MPoi>)treeItem.getParent());
        }
    }

    private void postPopulateRestoreSelection(CheckBoxTreeItem<MPoi> treeItem) {
        if (treeItem.getChildren().isEmpty()) {
            if (this.mVisibilityPreferences.getBoolean(this.getPath((MPoi)treeItem.getValue()), true)) {
                this.getCheckModel().check(treeItem);
            } else {
                this.getCheckModel().clearCheck(treeItem);
            }
        } else {
            for (TreeItem childTreeItem : treeItem.getChildren()) {
                this.postPopulateRestoreSelection((CheckBoxTreeItem<MPoi>)((CheckBoxTreeItem)childTreeItem));
            }
        }
    }

    class PoiTreeCell
    extends CheckBoxTreeCell<MPoi> {
        public PoiTreeCell() {
            this.createUI();
        }

        public void updateItem(MPoi poi, boolean empty) {
            super.updateItem((Object)poi, empty);
            if (poi == null || empty) {
                this.clearContent();
            } else {
                this.addContent(poi);
            }
        }

        private void addContent(MPoi poi) {
            this.setText(poi.getName());
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
        }
    }
}

