/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.poi;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.controlsfx.control.textfield.TextFields;
import org.mapton.api.MContextMenuItem;
import org.mapton.api.MDict;
import org.mapton.api.MPoi;
import org.mapton.api.MPoiManager;
import org.mapton.api.Mapton;
import org.mapton.api.ui.MFilterPopOver;
import org.mapton.core.ui.poi.PoiCategoryCheckTreeView;
import org.openide.util.Lookup;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class PoisView
extends BorderPane {
    private MenuItem mBrowseMenuItem;
    private Menu mContextCopyMenu;
    private ContextMenu mContextMenu;
    private EventHandler<MouseEvent> mContextMenuMouseEvent;
    private Menu mContextOpenMenu;
    private FilterPopOver mFilterPopOver;
    private TextField mFilterTextField;
    private Label mItemCountLabel;
    private ListView<MPoi> mListView;
    private final MPoiManager mManager = MPoiManager.getInstance();

    public PoisView() {
        this.createUI();
        this.initListeners();
        this.populateContextProviders();
        FxHelper.runLaterDelayed((long)1000L, () -> this.mManager.refresh());
    }

    private void createUI() {
        this.mFilterPopOver = new FilterPopOver();
        this.mFilterTextField = TextFields.createClearableTextField();
        this.mFilterTextField.setPromptText("%s %s".formatted(Dict.SEARCH.toString(), MDict.POI.toString()));
        this.mFilterTextField.setMinWidth(20.0);
        this.mListView = new ListView();
        this.mListView.itemsProperty().bind((ObservableValue)this.mManager.timeFilteredItemsProperty());
        this.mListView.setCellFactory(param -> new PoiListCell());
        Action refreshAction = new Action(Dict.REFRESH.toString(), event -> this.mManager.refresh());
        refreshAction.setGraphic((Node)MaterialIcon._Navigation.REFRESH.getImageView(Mapton.getIconSizeToolBarInt()));
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(refreshAction);
        actions.add(this.mFilterPopOver.getAction());
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.HIDE);
        FxHelper.adjustButtonWidth((Stream)toolBar.getItems().stream(), (double)Mapton.getIconSizeToolBarInt());
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        BorderPane topBorderPane = new BorderPane((Node)this.mFilterTextField);
        topBorderPane.setRight((Node)toolBar);
        toolBar.setMinWidth((double)(Mapton.getIconSizeToolBarInt() * 2) * 1.6);
        FxHelper.slimToolBar((ToolBar)toolBar);
        this.mItemCountLabel = new Label();
        this.mItemCountLabel.setAlignment(Pos.BASELINE_RIGHT);
        this.setTop((Node)topBorderPane);
        this.setCenter((Node)this.mListView);
        this.setBottom((Node)this.mItemCountLabel);
        this.mItemCountLabel.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.mBrowseMenuItem = new MenuItem(Dict.OPEN_IN_WEB_BROWSER.toString());
        MenuItem[] menuItemArray = new MenuItem[4];
        menuItemArray[0] = this.mBrowseMenuItem;
        menuItemArray[1] = new SeparatorMenuItem();
        this.mContextCopyMenu = new Menu(MDict.COPY_LOCATION.toString());
        menuItemArray[2] = this.mContextCopyMenu;
        this.mContextOpenMenu = new Menu(MDict.OPEN_LOCATION.toString());
        menuItemArray[3] = this.mContextOpenMenu;
        this.mContextMenu = new ContextMenu(menuItemArray);
    }

    private void initListeners() {
        this.mFilterTextField.textProperty().addListener((observable, oldValue, newValue) -> this.mManager.refresh(newValue));
        this.mManager.getTimeFilteredItems().addListener(c -> Platform.runLater(() -> {
            this.mItemCountLabel.setText("%d/%d".formatted(this.mManager.getTimeFilteredItems().size(), this.mManager.getAllItems().size()));
            this.mManager.restoreSelection();
        }));
        Lookup.getDefault().lookupResult(MContextMenuItem.class).addLookupListener(lookupEvent -> this.populateContextProviders());
        this.mContextMenuMouseEvent = mouseEvent -> {
            this.getScene().getWindow().requestFocus();
            this.mListView.requestFocus();
            MPoi poi = (MPoi)this.mListView.getSelectionModel().getSelectedItem();
            if (poi != null) {
                Mapton.getEngine().setLockedLatitude(poi.getLatitude());
                Mapton.getEngine().setLockedLongitude(poi.getLongitude());
                if (mouseEvent.isSecondaryButtonDown()) {
                    Mapton.getEngine().setLatitude(poi.getLatitude().doubleValue());
                    Mapton.getEngine().setLongitude(poi.getLongitude().doubleValue());
                    this.mBrowseMenuItem.setDisable(StringUtils.isBlank((CharSequence)poi.getUrl()));
                    this.mContextMenu.show((Node)this, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                } else if (mouseEvent.isPrimaryButtonDown()) {
                    this.mContextMenu.hide();
                }
            }
        };
        this.mListView.setOnMousePressed(this.mContextMenuMouseEvent);
        this.mListView.setOnMouseClicked(mouseEvent -> {
            MPoi poi;
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2 && (poi = (MPoi)this.mListView.getSelectionModel().getSelectedItem()) != null) {
                Mapton.getEngine().panTo(poi.getLatLon(), poi.getZoom().doubleValue());
            }
        });
        this.mListView.getSelectionModel().selectedItemProperty().addListener((ov, oldPoi, newPoi) -> this.mManager.setSelectedItem(newPoi));
        this.mManager.selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            if (this.mListView.getSelectionModel().getSelectedItem() != newValue) {
                this.mListView.getSelectionModel().select(newValue);
                this.mListView.getFocusModel().focus(this.mListView.getItems().indexOf(newValue));
                FxHelper.scrollToItemIfNotVisible(this.mListView, (Object)newValue);
            }
        });
        this.mBrowseMenuItem.setOnAction(actionEvent -> SystemHelper.desktopBrowse((String)((MPoi)this.mListView.getSelectionModel().getSelectedItem()).getUrl()));
    }

    private synchronized void populateContextProviders() {
        this.mContextCopyMenu.getItems().clear();
        this.mContextOpenMenu.getItems().clear();
        for (MContextMenuItem provider : Lookup.getDefault().lookupAll(MContextMenuItem.class)) {
            MenuItem menuItem = new MenuItem(provider.getName());
            switch (provider.getType()) {
                case COPY: {
                    this.mContextCopyMenu.getItems().add((Object)menuItem);
                    menuItem.setOnAction(actionEvent -> {
                        String s = provider.getUrl();
                        Mapton.getLog().v("Open location", s);
                        SystemHelper.copyToClipboard((String)s);
                    });
                    break;
                }
                case OPEN: {
                    this.mContextOpenMenu.getItems().add((Object)menuItem);
                    menuItem.setOnAction(actionEvent -> {
                        String s = provider.getUrl();
                        Mapton.getLog().v("Copy location", s);
                        SystemHelper.desktopBrowse((String)s);
                    });
                }
            }
        }
        this.mContextCopyMenu.getItems().sorted((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
        this.mContextCopyMenu.setVisible(!this.mContextCopyMenu.getItems().isEmpty());
        this.mContextOpenMenu.getItems().sorted((o1, o2) -> o1.getText().compareToIgnoreCase(o2.getText()));
        this.mContextOpenMenu.setVisible(!this.mContextOpenMenu.getItems().isEmpty());
    }

    public class FilterPopOver
    extends MFilterPopOver {
        private PoiCategoryCheckTreeView mCategoryCheckTreeView;

        public FilterPopOver() {
            this.createUI();
        }

        public void clear() {
            this.mCategoryCheckTreeView.getCheckModel().clearChecks();
            this.getPolygonFilterCheckBox().setSelected(false);
        }

        public void onPolygonFilterChange() {
        }

        public void reset() {
            this.mCategoryCheckTreeView.getCheckModel().checkAll();
            this.getPolygonFilterCheckBox().setSelected(false);
        }

        private void createUI() {
            this.mCategoryCheckTreeView = new PoiCategoryCheckTreeView();
            VBox vBox = new VBox((double)GAP, new Node[]{this.getButtonBox(), new Separator(), this.mCategoryCheckTreeView});
            FilterPopOver.autoSize((VBox)vBox);
            this.setContentNode((Node)vBox);
            MPoiManager poiManager = MPoiManager.getInstance();
            poiManager.polygonFilterProperty().bind((ObservableValue)this.getPolygonFilterCheckBox().selectedProperty());
            this.getPolygonFilterCheckBox().selectedProperty().addListener((observable, oldValue, newValue) -> poiManager.refresh());
        }
    }

    class PoiListCell
    extends ListCell<MPoi> {
        private final Label mDesc1Label = new Label();
        private final Label mNameLabel = new Label();
        private final String mStyleBold = "-fx-font-weight: bold;";
        private VBox mVBox;

        public PoiListCell() {
            this.createUI();
        }

        protected void updateItem(MPoi poi, boolean empty) {
            super.updateItem((Object)poi, empty);
            if (poi == null || empty) {
                this.clearContent();
            } else {
                this.addContent(poi);
            }
        }

        private void addContent(MPoi poi) {
            this.setText(null);
            this.mNameLabel.setText(poi.getName());
            this.mDesc1Label.setText("%s: %s".formatted(poi.getProvider(), poi.getCategory()));
            LinkedHashMap<String, String> rows = new LinkedHashMap<String, String>();
            rows.put(Dict.NAME.toString(), StringUtils.defaultString((String)poi.getName()));
            rows.put(Dict.CATEGORY.toString(), StringUtils.defaultString((String)poi.getCategory()));
            rows.put(Dict.SOURCE.toString(), StringUtils.defaultString((String)poi.getProvider()));
            rows.put(Dict.DESCRIPTION.toString(), StringUtils.defaultString((String)poi.getDescription()));
            rows.put(Dict.TAGS.toString(), StringUtils.defaultString((String)poi.getTags()));
            rows.put("URL", StringUtils.defaultString((String)poi.getUrl()));
            int length = 0;
            for (Object string : rows.keySet()) {
                length = Math.max(length, ((String)string).length());
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : rows.entrySet()) {
                sb.append(StringUtils.rightPad((String)((String)entry.getKey()), (int)length, (String)" ")).append(" : ").append((String)entry.getValue()).append("\n");
            }
            Tooltip tooltip = new Tooltip(sb.toString());
            tooltip.setFont(Font.font((String)"monospaced"));
            this.setTooltip(tooltip);
            this.setGraphic((Node)this.mVBox);
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
            this.mNameLabel.setStyle("-fx-font-weight: bold;");
            this.mVBox = new VBox(new Node[]{this.mNameLabel, this.mDesc1Label});
        }
    }
}

