/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.ui.simple_object_storage;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.VBox;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.ToggleSwitch;
import org.mapton.api.MSimpleObjectStorageBoolean;
import org.mapton.core.ui.simple_object_storage.BaseTab;
import org.openide.util.Lookup;
import se.trixon.almond.util.fx.FxHelper;

public class BooleanStorageTab<T extends MSimpleObjectStorageBoolean>
extends BaseTab {
    private final Class<T> mClass;
    private final HashMap<Class, ToggleSwitch> mClassToToggleSwitch = new HashMap();
    private final VBox mItemBox = new VBox((double)FxHelper.getUIScaled((int)8));
    private final ScrollPane mScrollPane;

    public BooleanStorageTab(Class<T> c, String title) {
        super(title);
        this.mClass = c;
        this.mScrollPane = new ScrollPane((Node)this.mItemBox);
        this.setContent((Node)this.mScrollPane);
        this.mScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.mScrollPane.setFitToWidth(true);
        this.mItemBox.setPadding(FxHelper.getUIScaledInsets((double)8.0));
        Lookup.getDefault().lookupResult(c).addLookupListener(ev -> this.populateItems());
        this.populateItems();
    }

    public void load(Object object) {
        Lookup.getDefault().lookupAll(this.mClass).forEach(simpleStorage -> this.mClassToToggleSwitch.get(simpleStorage.getClass()).setSelected(this.mManager.getBoolean(simpleStorage.getClass(), (Boolean)simpleStorage.getDefaultValue()).booleanValue()));
    }

    public void save(Object object) {
        Lookup.getDefault().lookupAll(this.mClass).forEach(simpleStorage -> this.mManager.putBoolean(simpleStorage.getClass(), Boolean.valueOf(this.mClassToToggleSwitch.get(simpleStorage.getClass()).isSelected())));
    }

    private void populateItems() {
        FxHelper.runLater(() -> {
            ArrayList simpleStorages = new ArrayList(Lookup.getDefault().lookupAll(this.mClass));
            Comparator c1 = (o1, o2) -> StringUtils.defaultString((String)o1.getGroup()).compareToIgnoreCase(StringUtils.defaultString((String)o2.getGroup()));
            Comparator c2 = (o1, o2) -> StringUtils.defaultString((String)o1.getName()).compareToIgnoreCase(StringUtils.defaultString((String)o2.getName()));
            simpleStorages.sort(c1.thenComparing(c2));
            HashSet<String> groups = new HashSet<String>();
            this.mClassToToggleSwitch.clear();
            for (MSimpleObjectStorageBoolean simpleStorage : simpleStorages) {
                ToggleSwitch toggleSwitch = new ToggleSwitch(simpleStorage.getName());
                toggleSwitch.prefWidthProperty().bind((ObservableValue)this.mItemBox.widthProperty());
                VBox box = new VBox(new Node[]{toggleSwitch});
                if (StringUtils.isNotBlank((CharSequence)simpleStorage.getTooltipText())) {
                    toggleSwitch.setTooltip(new Tooltip(simpleStorage.getTooltipText()));
                }
                this.mClassToToggleSwitch.put(simpleStorage.getClass(), toggleSwitch);
                String group = simpleStorage.getGroup();
                if (!groups.contains(group)) {
                    groups.add(group);
                    box.getChildren().add(0, (Object)this.getGroupLabel(group));
                }
                this.mItemBox.getChildren().add((Object)box);
            }
        });
    }
}

