/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.updater;

import java.io.File;
import java.util.ResourceBundle;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.Timer;
import org.apache.commons.lang3.ObjectUtils;
import org.mapton.api.MNotificationIcons;
import org.mapton.api.MUpdater;
import org.mapton.core.updater.UpdaterManager;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.Almond;
import se.trixon.almond.util.SystemHelper;

public class UpdateNotificatorInitializer
implements Runnable {
    private final ResourceBundle mBundle = NbBundle.getBundle(UpdateNotificatorInitializer.class);
    private final UpdaterManager mUpdaterManager = UpdaterManager.getInstance();

    public UpdateNotificatorInitializer() {
        this.mUpdaterManager.populate();
    }

    @Override
    public void run() {
        Timer timer = new Timer((int)TimeUnit.HOURS.toMillis(1L), actionEvent -> this.check());
        timer.setInitialDelay((int)TimeUnit.MINUTES.toMillis(2L));
        timer.start();
    }

    private void check() {
        for (MUpdater.ByFile updater : Lookup.getDefault().lookupAll(MUpdater.ByFile.class)) {
            File file = updater.getFile();
            if (!ObjectUtils.allNotNull((Object[])new Object[]{updater.getAgeLimit(), file}) || file.exists() && SystemHelper.age((long)file.lastModified()) < updater.getAgeLimit()) continue;
            this.displayNotification();
            break;
        }
    }

    private void displayNotification() {
        NotificationDisplayer.getDefault().notify(this.mBundle.getString("update_available"), (Icon)MNotificationIcons.getInformationIcon(), this.mBundle.getString("updater_tool"), actionEvent -> Almond.openAndActivateTopComponent("UpdaterTopComponent"), NotificationDisplayer.Priority.NORMAL);
    }
}

