/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.updater;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.mapton.api.MPrint;
import org.mapton.api.MUpdater;
import org.openide.util.Lookup;

public class UpdaterManager {
    private final ObjectProperty<ObservableList<MUpdater>> mItemsProperty = new SimpleObjectProperty();
    private final MPrint mPrint = new MPrint("updater.logger");
    private final BooleanProperty mSelectedProperty = new SimpleBooleanProperty(false);

    public static UpdaterManager getInstance() {
        return Holder.INSTANCE;
    }

    private UpdaterManager() {
        this.mItemsProperty.set((Object)FXCollections.observableArrayList());
        Lookup.getDefault().lookupResult(MUpdater.class).addLookupListener(lookupEvent -> this.populate());
        this.populate();
    }

    public ObservableList<MUpdater> getItems() {
        return (ObservableList)this.mItemsProperty.get();
    }

    public ObjectProperty<ObservableList<MUpdater>> itemsProperty() {
        return this.mItemsProperty;
    }

    public void populate() {
        new Thread(() -> {
            ArrayList updaters = new ArrayList(Lookup.getDefault().lookupAll(MUpdater.class));
            for (MUpdater updater : updaters) {
                updater.setMarkedForUpdate(updater.isOutOfDate());
                if (updater.isAutoUpdate()) {
                    updater.setAutoUpdatePostRunnable(() -> this.populate());
                }
                String status = updater.isOutOfDate() ? "is out of date" : "OK";
                this.mPrint.out("%s: %s %s".formatted("Status check", updater.getName(), status));
            }
            Comparator c1 = (o1, o2) -> Boolean.compare(o2.isOutOfDate(), o1.isMarkedForUpdate());
            Comparator c2 = (o1, o2) -> o1.getCategory().compareTo(o2.getCategory());
            Comparator c3 = (o1, o2) -> o1.getName().compareTo(o2.getName());
            updaters.sort(c1.thenComparing(c2).thenComparing(c3));
            Platform.runLater(() -> {
                this.getItems().setAll((Collection)updaters);
                this.refreshSelectedProperty();
            });
        }, this.getClass().getCanonicalName()).start();
    }

    public void refreshSelectedProperty() {
        boolean markedForUpdate = false;
        for (MUpdater item : this.getItems()) {
            if (!item.isMarkedForUpdate()) continue;
            markedForUpdate = true;
            break;
        }
        this.mSelectedProperty.set(markedForUpdate);
    }

    public BooleanProperty selectedProperty() {
        return this.mSelectedProperty;
    }

    private static class Holder {
        private static final UpdaterManager INSTANCE = new UpdaterManager();

        private Holder() {
        }
    }
}

