/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.core.updater;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ToolBar;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import org.controlsfx.control.action.Action;
import org.controlsfx.control.action.ActionUtils;
import org.mapton.api.MUpdater;
import org.mapton.api.Mapton;
import org.mapton.core.updater.UpdaterManager;
import org.mapton.core.updater.UpdaterMaskerPane;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.LogListener;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.fx.control.LogPanel;
import se.trixon.almond.util.icons.material.MaterialIcon;

public class UpdaterView
extends BorderPane
implements LogListener {
    private ListView<MUpdater> mListView;
    private LogPanel mLogPanel;
    private final UpdaterManager mUpdaterManager = UpdaterManager.getInstance();
    private UpdaterMaskerPane mUpdaterMaskerPane;

    public UpdaterView() {
        this.createUI();
        Mapton.getGlobalState().addListener(gsce -> this.mLogPanel.println((String)gsce.getObject()), new String[]{"updater.logger"});
    }

    public void println(String s) {
        this.mLogPanel.println(s);
    }

    private void createUI() {
        this.mListView = new ListView();
        this.mListView.setMinWidth((double)FxHelper.getUIScaled((int)350));
        this.mListView.setCellFactory(listView -> new UpdaterListCell());
        this.mListView.itemsProperty().bind(this.mUpdaterManager.itemsProperty());
        this.mUpdaterMaskerPane = new UpdaterMaskerPane();
        this.mUpdaterMaskerPane.setContent((Node)this.mListView);
        this.mLogPanel = new LogPanel();
        this.mLogPanel.setMonospaced();
        Action updateAction = new Action(Dict.UPDATE.toString(), event -> this.update());
        updateAction.setGraphic((Node)MaterialIcon._Action.SYSTEM_UPDATE_ALT.getImageView(Mapton.getIconSizeToolBarInt()));
        Action refreshAction = new Action(Dict.REFRESH.toString(), event -> this.mUpdaterManager.populate());
        refreshAction.setGraphic((Node)MaterialIcon._Navigation.REFRESH.getImageView(Mapton.getIconSizeToolBarInt()));
        Action clearAction = new Action(Dict.CLEAR.toString(), event -> this.mLogPanel.clear());
        clearAction.setGraphic((Node)MaterialIcon._Content.CLEAR.getImageView(Mapton.getIconSizeToolBarInt()));
        List<Action> actions = Arrays.asList(refreshAction, updateAction, clearAction);
        ToolBar toolBar = ActionUtils.createToolBar(actions, (ActionUtils.ActionTextBehavior)ActionUtils.ActionTextBehavior.SHOW);
        FxHelper.undecorateButtons((Stream)toolBar.getItems().stream());
        FxHelper.slimToolBar((ToolBar)toolBar);
        updateAction.disabledProperty().bind((ObservableValue)this.mUpdaterMaskerPane.runningProperty().or((ObservableBooleanValue)this.mUpdaterManager.selectedProperty().not()));
        refreshAction.disabledProperty().bind((ObservableValue)this.mUpdaterMaskerPane.runningProperty());
        this.setLeft(this.mUpdaterMaskerPane.getNode());
        this.setCenter((Node)this.mLogPanel);
        this.setTop((Node)toolBar);
        SystemHelper.runLaterDelayed((long)1000L, () -> this.mUpdaterManager.populate());
    }

    private void update() {
        for (MUpdater updater : this.mListView.getItems()) {
            if (!updater.isMarkedForUpdate()) continue;
            this.mUpdaterMaskerPane.update((ObservableList<MUpdater>)this.mListView.getItems(), () -> this.mUpdaterManager.populate());
            break;
        }
    }

    class UpdaterListCell
    extends ListCell<MUpdater> {
        private final Label mCategoryLabel = new Label();
        private final Label mCommentLabel = new Label();
        private final Font mHeaderFont;
        private final Label mLastUpdatedLabel = new Label();
        private final CheckBox mNameCheckBox = new CheckBox();
        private VBox mVBox;

        public UpdaterListCell() {
            this.mHeaderFont = Font.font((String)Font.getDefault().getFamily(), (FontWeight)FontWeight.BOLD, (double)(FxHelper.getScaledFontSize() * 1.1));
            this.createUI();
        }

        protected void updateItem(MUpdater updater, boolean empty) {
            super.updateItem((Object)updater, empty);
            if (updater == null || empty) {
                this.clearContent();
            } else {
                this.addContent(updater);
            }
        }

        private void addContent(MUpdater updater) {
            this.setText(null);
            this.mNameCheckBox.setText(updater.getName());
            this.mNameCheckBox.setSelected(updater.isOutOfDate());
            this.mNameCheckBox.selectedProperty().addListener((ov, t, t1) -> {
                updater.setMarkedForUpdate(t1.booleanValue());
                UpdaterView.this.mUpdaterManager.refreshSelectedProperty();
            });
            this.mCategoryLabel.setText(updater.getCategory());
            this.mCommentLabel.setText(updater.getComment());
            this.mLastUpdatedLabel.setText(updater.getLastUpdated());
            this.setGraphic((Node)this.mVBox);
        }

        private void clearContent() {
            this.setText(null);
            this.setGraphic(null);
        }

        private void createUI() {
            Font font = Font.font((double)(FxHelper.getScaledFontSize() * 0.9));
            Font italicFont = Font.font((String)font.getFamily(), (FontPosture)FontPosture.ITALIC, (double)font.getSize());
            this.mNameCheckBox.setFont(this.mHeaderFont);
            this.mCategoryLabel.setFont(font);
            this.mCommentLabel.setFont(italicFont);
            this.mLastUpdatedLabel.setFont(font);
            this.mVBox = new VBox((double)FxHelper.getUIScaled((int)2), new Node[]{this.mCategoryLabel, this.mNameCheckBox, this.mCommentLabel, this.mLastUpdatedLabel});
            this.mVBox.setPadding(FxHelper.getUIScaledInsets((double)4.0));
        }
    }
}

