/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import se.trixon.almond.util.swing.dialogs.SimpleDialog;

public class Almond {
    public static boolean ASK_CONFIRM_EXIT = false;
    public static int ICON_LARGE = 24;
    public static int ICON_SMALL = 16;
    private static final WindowManager WINDOW_MANAGER = WindowManager.getDefault();
    private static JFrame sFrame;
    private static boolean sWasSelected;

    public static void activateWindow(boolean active) {
        SwingUtilities.invokeLater(() -> Almond.getFrame().setEnabled(active));
    }

    public static Frame getFrame() {
        return sFrame;
    }

    public static <T extends TopComponent> T getTopComponent(String id, Class<T> type) {
        return (T)((TopComponent)type.cast(WINDOW_MANAGER.findTopComponent(id)));
    }

    public static TopComponent getTopComponent(String id) {
        return Almond.getTopComponent(id, TopComponent.class);
    }

    public static boolean isSelected(String preferredID) {
        TopComponent topComponent = WINDOW_MANAGER.findTopComponent(preferredID);
        try {
            Mode mode = WINDOW_MANAGER.findMode(topComponent);
            return mode.getSelectedTopComponent() == topComponent;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void openAndActivateTopComponent(String id) {
        SwingUtilities.invokeLater(() -> {
            try {
                WINDOW_MANAGER.findTopComponent(id).open();
                WINDOW_MANAGER.findTopComponent(id).requestActive();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void openTopComponent(String id) {
        SwingUtilities.invokeLater(() -> {
            try {
                WINDOW_MANAGER.findTopComponent(id).open();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public static void openTopComponent(String id, boolean invokeAndWait) {
        Runnable r = () -> {
            try {
                WINDOW_MANAGER.findTopComponent(id).open();
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        if (!SwingUtilities.isEventDispatchThread() && invokeAndWait) {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                Thread.currentThread().interrupt();
            }
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static synchronized boolean requestActive(String preferredID) {
        Runnable r = () -> {
            try {
                TopComponent topComponent = WINDOW_MANAGER.findTopComponent(preferredID);
                Mode mode = WINDOW_MANAGER.findMode(topComponent);
                sWasSelected = mode.getSelectedTopComponent() == topComponent;
                topComponent.requestActive();
            }
            catch (Exception e) {
                sWasSelected = false;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(r);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                Thread.currentThread().interrupt();
            }
        }
        return sWasSelected;
    }

    public static void setFrame(JFrame frame) {
        SimpleDialog.setParent((Component)frame);
        sFrame = frame;
    }
}

