/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;
import se.trixon.almond.util.Dict;

public class NbLog {
    public static final int ASSERT = 7;
    public static final int DEBUG = 3;
    public static final int ERROR = 6;
    public static final int INFO = 4;
    public static final int VERBOSE = 2;
    public static final int WARN = 5;
    public static String sGlobalTag = Dict.APPLICATION.toString();
    private static boolean sActive = true;
    private static DateTimeFormatter sDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH.mm.ss: ");
    private static InputOutput sInputOutput;
    private static int sLevel;
    private static boolean sUseGlobalTag;
    private static boolean sUseTimestamps;

    public static synchronized void a(Class c, String msg) {
        NbLog.a(NbLog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void a(String tag, String msg) {
        if (sActive && sLevel <= 7) {
            NbLog.printErr("ASSERT", NbLog.getMessage(NbLog.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public static synchronized void d(Class c, String msg) {
        NbLog.d(NbLog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void d(String tag, String msg) {
        if (sActive && sLevel <= 3) {
            NbLog.print("DEBUG", NbLog.getMessage(NbLog.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public static synchronized void e(Class c, String msg) {
        NbLog.e(NbLog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void e(String tag, String msg) {
        if (sActive && sLevel <= 6) {
            NbLog.printErr("ERROR", NbLog.getMessage(NbLog.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public static synchronized String getGlobalTag() {
        return sGlobalTag;
    }

    public static synchronized int getLevel() {
        return sLevel;
    }

    public static synchronized void i(Class c, String msg) {
        NbLog.i(NbLog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void i(String tag, String msg) {
        if (sActive && sLevel <= 4) {
            NbLog.print("INFO", NbLog.getMessage(NbLog.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public static synchronized boolean isActive() {
        return sActive;
    }

    public static synchronized boolean isUseGlobalTag() {
        return sUseGlobalTag;
    }

    public static synchronized boolean isUseTimestamps() {
        return sUseTimestamps;
    }

    public static synchronized void reinit() {
        sInputOutput = IOProvider.getDefault().getIO(sGlobalTag, false);
    }

    public static synchronized void select() {
        sInputOutput.select();
    }

    public static synchronized void setActive(boolean active) {
        sActive = active;
    }

    public static synchronized void setGlobalTag(String globalTag) {
        sGlobalTag = globalTag;
    }

    public static synchronized void setLevel(int level) {
        sLevel = level;
    }

    public static synchronized void setUseGlobalTag(boolean useGlobalTag) {
        sUseGlobalTag = useGlobalTag;
    }

    public static synchronized void setUseTimestamps(boolean useTimestamps) {
        sUseTimestamps = useTimestamps;
    }

    public static synchronized void v(Class<?> c, String msg) {
        NbLog.v(NbLog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void v(String tag, String msg) {
        if (sActive && sLevel <= 2) {
            NbLog.print("VERBOSE", NbLog.getMessage(NbLog.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    public static synchronized void w(Class c, String msg) {
        NbLog.w(NbLog.getTag(c.getCanonicalName()), msg);
    }

    public static synchronized void w(String tag, String msg) {
        if (sActive && sLevel <= 5) {
            NbLog.printErr("WARNING", NbLog.getMessage(NbLog.getTag(tag), StringUtils.defaultString((String)msg, (String)"NULL")));
        }
    }

    private static String getMessage(String s1, String s2) {
        if (StringUtils.isBlank((CharSequence)s1)) {
            return s2;
        }
        return "[%s] %s".formatted(s1, s2);
    }

    private static String getMessage(String s1, String s2, String s3) {
        return "[%s] [%s] %s".formatted(s1, s2, s3);
    }

    private static String getTag(String localTag) {
        String tag = sUseGlobalTag ? sGlobalTag : localTag;
        return tag;
    }

    private static void print(String levelClass, String message) {
        SwingUtilities.invokeLater(() -> {
            try (OutputWriter outputWriter = sInputOutput.getOut();){
                NbLog.printDate(outputWriter);
                outputWriter.print(levelClass + " ");
                outputWriter.println(message);
            }
        });
    }

    private static void printDate(OutputWriter outputWriter) {
        if (sUseTimestamps) {
            outputWriter.print(LocalDateTime.now().format(sDateTimeFormatter));
        }
    }

    private static void printErr(String levelClass, String message) {
        SwingUtilities.invokeLater(() -> {
            try (OutputWriter outputWriter = sInputOutput.getErr();){
                NbLog.printDate(outputWriter);
                outputWriter.print(levelClass + " ");
                outputWriter.println(message);
            }
        });
    }

    static {
        sLevel = 2;
        sUseGlobalTag = false;
        sUseTimestamps = true;
        SwingUtilities.invokeLater(() -> {
            sInputOutput = IOProvider.getDefault().getIO(sGlobalTag, false);
        });
    }
}

