/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class NbPrint {
    private DateTimeFormatter mDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH.mm.ss: ");
    private InputOutput mInputOutput;
    private boolean mUseTimestamps = true;

    public NbPrint(String title) {
        SwingUtilities.invokeLater(() -> {
            this.mInputOutput = IOProvider.getDefault().getIO(title, false);
        });
    }

    public void err(String x) {
        SwingUtilities.invokeLater(() -> {
            try (OutputWriter outputWriter = this.mInputOutput.getErr();){
                this.printDate(outputWriter);
                outputWriter.println(StringUtils.defaultString((String)x, (String)"NULL"));
            }
        });
    }

    public void err(Object x) {
        if (x == null) {
            this.err("NULL");
        } else {
            this.err(String.valueOf(x));
        }
    }

    public synchronized boolean isUseTimestamps() {
        return this.mUseTimestamps;
    }

    public void out(String x) {
        SwingUtilities.invokeLater(() -> {
            try (OutputWriter outputWriter = this.mInputOutput.getOut();){
                this.printDate(outputWriter);
                outputWriter.println(StringUtils.defaultString((String)x, (String)"NULL"));
            }
        });
    }

    public void out(Object x) {
        if (x == null) {
            this.out("NULL");
        } else {
            this.out(String.valueOf(x));
        }
    }

    public synchronized void select() {
        SwingUtilities.invokeLater(() -> this.mInputOutput.select());
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.mDateTimeFormatter = dateTimeFormatter;
    }

    public synchronized void setUseTimestamps(boolean useTimestamps) {
        this.mUseTimestamps = useTimestamps;
    }

    private void printDate(OutputWriter outputWriter) {
        if (this.mUseTimestamps) {
            outputWriter.print(LocalDateTime.now().format(this.mDateTimeFormatter));
        }
    }
}

