/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.dialogs;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.io.FilenameUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import se.trixon.almond.util.Dict;

public class NbSimpleDialog {
    private static final JFileChooser sFileChooser = new JFileChooser();
    private static FileNameExtensionFilter sFilter;
    private static Component sParent;
    private static File sPath;
    private static File[] sPaths;
    private static String sTitle;

    public static void addFilter(FileNameExtensionFilter filter) {
        sFileChooser.addChoosableFileFilter(filter);
    }

    public static void clearFilters() {
        sFileChooser.resetChoosableFileFilters();
    }

    public static FileNameExtensionFilter getFilter() {
        return sFilter;
    }

    public static Component getParent() {
        return sParent;
    }

    public static File getPath() {
        return sPath;
    }

    public static File[] getPaths() {
        return sPaths;
    }

    public static String getTitle() {
        return sTitle;
    }

    public static boolean openFile() {
        return NbSimpleDialog.openFile(false);
    }

    public static boolean openFile(boolean multiSelection) {
        sFileChooser.setFileSelectionMode(0);
        sFileChooser.setMultiSelectionEnabled(multiSelection);
        sPaths = new File[0];
        int result = sFileChooser.showOpenDialog(sParent);
        if (result == 0) {
            if (multiSelection) {
                sPaths = sFileChooser.getSelectedFiles();
            } else {
                sPath = sFileChooser.getSelectedFile();
            }
        }
        return result == 0;
    }

    public static boolean openFileAndDirectoy() {
        return NbSimpleDialog.openFileAndDirectoy(false);
    }

    public static boolean openFileAndDirectoy(boolean multiSelection) {
        sFileChooser.setFileSelectionMode(2);
        sFileChooser.setMultiSelectionEnabled(multiSelection);
        sPaths = new File[0];
        int result = sFileChooser.showOpenDialog(sParent);
        if (result == 0) {
            if (multiSelection) {
                sPaths = sFileChooser.getSelectedFiles();
            } else {
                sPath = sFileChooser.getSelectedFile();
            }
        }
        return result == 0;
    }

    public static boolean saveFile(String ... extensions) {
        int result = sFileChooser.showSaveDialog(sParent);
        if (result != 0) {
            return false;
        }
        File file = sFileChooser.getSelectedFile();
        if (extensions != null && extensions.length > 0) {
            String fileExt = FilenameUtils.getExtension((String)file.getName());
            boolean validExt = false;
            for (String extension : extensions) {
                if (!fileExt.toLowerCase().equalsIgnoreCase(extension)) continue;
                validExt = true;
                break;
            }
            if (!validExt) {
                Object suffix = file.getName().endsWith(".") ? extensions[0] : "." + extensions[0];
                file = new File(file.getAbsolutePath() + (String)suffix);
            }
        }
        if (file.exists()) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)Dict.Dialog.MESSAGE_FILE_EXISTS.toString().formatted(file.getAbsolutePath()), Dict.Dialog.TITLE_FILE_EXISTS.toString(), -1, 3, null, null);
            Object value = DialogDisplayer.getDefault().notify(notifyDescriptor);
            if (NotifyDescriptor.CANCEL_OPTION == value) {
                return NbSimpleDialog.saveFile(new String[0]);
            }
        }
        sPath = file;
        return true;
    }

    public static void selectColor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static boolean selectDirectory() {
        sFileChooser.setFileSelectionMode(1);
        int result = sFileChooser.showOpenDialog(sParent);
        if (result == 0) {
            sPath = sFileChooser.getSelectedFile();
        }
        return result == 0;
    }

    public static void selectFont() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static void setFilter(FileNameExtensionFilter filter) {
        sFilter = filter;
        sFileChooser.setFileFilter(filter);
    }

    public static void setParent(Component parent) {
        sParent = parent;
    }

    public static void setPath(File path) {
        sPath = path;
        sFileChooser.setCurrentDirectory(sPath);
    }

    public static void setSelectedFile(File file) {
        sFileChooser.setSelectedFile(file);
    }

    public static void setTitle(String title) {
        sTitle = title;
        sFileChooser.setDialogTitle(sTitle);
    }

    public static void showHidden(boolean showHidden) {
        sFileChooser.setFileHidingEnabled(!showHidden);
    }

    private NbSimpleDialog() {
    }

    static {
        sPaths = new File[0];
    }
}

