/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.dialogs;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.trixon.almond.nbp.dialogs.NbOptionalDialog;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SnapHelper;

public class NbSnapHelper {
    public static void checkSnapStatus(Class cls, String id, String snapName, String ... plugsAndSlots) {
        try {
            if (SnapHelper.isSnap()) {
                StringBuilder sb = new StringBuilder();
                for (String plugsAndSlot : plugsAndSlots) {
                    if (SnapHelper.isConnected((String)plugsAndSlot)) continue;
                    sb.append("sudo snap connect %s:%s\n".formatted(snapName, plugsAndSlot));
                }
                if (sb.length() > 0) {
                    String message = "It looks like you are running '%s' as a snap".formatted(snapName) + "\n\nFor a better experience, consider executing:\n\n" + sb.toString() + "\nor through the Permissions UI in the snap-store application.";
                    NbOptionalDialog.requestShowDialog(cls, id, 1, Dict.INFORMATION.toString(), message, null);
                }
            }
        }
        catch (IOException | InterruptedException ex) {
            Logger.getLogger(cls.getName()).log(Level.SEVERE, null, ex);
            Thread.currentThread().interrupt();
        }
    }
}

