/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.fx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ResourceBundle;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.swing.SwingHelper;

public abstract class FxTopComponent
extends TopComponent {
    private static int FX_DELAY_LONG = 0;
    private static int FX_DELAY_SHORT = 0;
    private static final WindowManager WINDOW_MANAGER = WindowManager.getDefault();
    private transient ResourceBundle mBundle;
    private boolean mComponentOpenedFirstTime = true;
    private final JFXPanel mFxPanel = new JFXPanel();
    private transient Scene mScene;

    public FxTopComponent() {
        this.setLayout(new BorderLayout());
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        this.add(progressBar, "North");
        this.repaint();
        this.revalidate();
    }

    public ResourceBundle getBundle() {
        if (this.mBundle == null) {
            this.mBundle = NbBundle.getBundle(((Object)((Object)this)).getClass());
        }
        return this.mBundle;
    }

    public String getBundleString(String key) {
        return this.getBundle().getString(key);
    }

    public JFXPanel getFxPanel() {
        return this.mFxPanel;
    }

    public Scene getScene() {
        return this.mScene;
    }

    public void requestSceneFocus() {
        this.getScene().getWindow().requestFocus();
    }

    public void resetFx() {
        this.removeAll();
        this.mFxPanel.setVisible(true);
        this.add((Component)this.mFxPanel, "Center");
    }

    public void setScene(Scene scene) {
        this.mScene = scene;
        FxHelper.loadDarkTheme((Scene)scene);
    }

    public void toggleOpened() {
        boolean activeInMode;
        boolean bl = activeInMode = WINDOW_MANAGER.findMode((TopComponent)this).getSelectedTopComponent() == this;
        if (activeInMode) {
            this.close();
        } else {
            this.open();
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        FxHelper.runLaterDelayed((long)FX_DELAY_SHORT, () -> this.fxComponentActivated());
    }

    protected void componentClosed() {
        FxHelper.runLaterDelayed((long)FX_DELAY_SHORT, () -> {
            this.fxComponentClosed();
            SwingUtilities.invokeLater(() -> super.componentClosed());
        });
    }

    protected void componentDeactivated() {
        FxHelper.runLaterDelayed((long)FX_DELAY_SHORT, () -> {
            this.fxComponentDeactivated();
            SwingUtilities.invokeLater(() -> super.componentDeactivated());
        });
    }

    protected void componentHidden() {
        FxHelper.runLaterDelayed((long)FX_DELAY_SHORT, () -> {
            this.fxComponentHidden();
            SwingUtilities.invokeLater(() -> super.componentHidden());
        });
    }

    protected void componentOpened() {
        super.componentOpened();
        FxHelper.runLaterDelayed((long)50L, () -> {
            if (this.mComponentOpenedFirstTime) {
                this.mComponentOpenedFirstTime = false;
                this.initFX();
                this.mFxPanel.setScene(this.mScene);
                SwingHelper.runLaterDelayed((long)0L, () -> {
                    this.removeAll();
                    this.add((Component)this.mFxPanel, "Center");
                    this.repaint();
                    this.revalidate();
                    FxHelper.runLaterDelayed((long)100L, () -> this.fxPostConstructor());
                });
            }
            this.fxComponentOpened();
        });
    }

    protected void componentShowing() {
        super.componentShowing();
        FxHelper.runLaterDelayed((long)FX_DELAY_SHORT, () -> this.fxComponentShowing());
    }

    protected void fxComponentActivated() {
    }

    protected void fxComponentClosed() {
    }

    protected void fxComponentDeactivated() {
    }

    protected void fxComponentHidden() {
    }

    protected void fxComponentOpened() {
    }

    protected void fxComponentShowing() {
    }

    protected void fxPostConstructor() {
    }

    protected abstract void initFX();
}

