/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.fx;

import java.util.Properties;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.web.HTMLEditor;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import se.trixon.almond.nbp.fx.FxTopComponent;
import se.trixon.almond.util.Dict;

@TopComponent.Description(preferredID="NotesHtmlTopComponent", persistenceType=0)
public final class NotesHtmlTopComponent
extends FxTopComponent {
    private static final String KEY_NOTES_HTML = "noteshtml";
    private final transient Preferences mPreferences = NbPreferences.forModule(NotesHtmlTopComponent.class);
    private transient HTMLEditor mEditor;

    public NotesHtmlTopComponent() {
        this.setName(Dict.NOTES.toString());
    }

    @Override
    protected void fxComponentOpened() {
        super.fxComponentOpened();
        this.mEditor.setHtmlText(this.mPreferences.get(KEY_NOTES_HTML, ""));
    }

    @Override
    protected void initFX() {
        this.mEditor = new HTMLEditor();
        this.setScene(new Scene((Parent)this.mEditor));
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        Platform.runLater(() -> this.mPreferences.put(KEY_NOTES_HTML, this.mEditor.getHtmlText()));
    }
}

