/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.fx;

import java.util.Properties;
import java.util.prefs.Preferences;
import javafx.application.Platform;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import se.trixon.almond.nbp.fx.FxTopComponent;
import se.trixon.almond.util.Dict;

@TopComponent.Description(preferredID="NotesTopComponent", persistenceType=0)
public final class NotesTopComponent
extends FxTopComponent {
    private static final String KEY_NOTES = "notes";
    private final transient Preferences mPreferences = NbPreferences.forModule(NotesTopComponent.class);
    private transient TextArea mTextArea;

    public NotesTopComponent() {
        this.setName(Dict.NOTES.toString());
    }

    @Override
    protected void fxComponentOpened() {
        super.fxComponentOpened();
        this.mTextArea.setText(this.mPreferences.get(KEY_NOTES, ""));
    }

    @Override
    protected void initFX() {
        this.mTextArea = new TextArea();
        this.setScene(new Scene((Parent)this.mTextArea));
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        Platform.runLater(() -> this.mPreferences.put(KEY_NOTES, this.mTextArea.getText()));
    }
}

