/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.imageviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.DropDownButtonFactory;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import se.trixon.almond.nbp.imageviewer.ImagePanel;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.icons.material.MaterialIcon;
import se.trixon.almond.util.swing.SwingHelper;

public class ImageViewPanel
extends JPanel {
    private static final int ICON_SIZE = 36;
    private ImageIcon mPauseImageIcon;
    private ImageIcon mPlayImageIcon;
    private JButton mStartButton;
    private final LinkedList<File> mFiles = new LinkedList();
    private int mIndex;
    private Timer mTimer;
    private DropTarget mDropTarget;
    private JPanel controlPanel;
    private ImagePanel imagePanel;
    private JLabel label;
    private JButton nextButton;
    private JMenuItem playAllMenuItem;
    private JMenuItem playMenuItem;
    private JPopupMenu playPopupMenu;
    private JButton prevButton;
    private JLabel previewLabel;
    private JCheckBoxMenuItem reversedCheckBoxMenuItem;
    private JSlider slider;
    private JMenuItem speedMenuItem;
    private JSlider speedSlider;
    private JToolBar toolBar;
    private JToolBar.Separator toolbarSeparator1;

    public ImageViewPanel() {
        this.initComponents();
        this.init();
        this.initDropTarget();
    }

    public void add(File[] files) {
        this.mFiles.addAll(Arrays.asList(files));
        this.fileListChanged();
    }

    public void addReplace(File[] files) {
        this.mFiles.clear();
        this.add(files);
    }

    public void clear() {
        this.mFiles.clear();
    }

    private void display(int index) {
        BufferedImage bufferedImage = null;
        Object name = "";
        if (index > -1) {
            try {
                bufferedImage = ImageIO.read(this.mFiles.get(index));
                name = bufferedImage == null ? "Error loading: " + this.mFiles.get(index).getName() : this.mFiles.get(index).getName();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.imagePanel.setImage(bufferedImage);
        this.label.setText((String)name);
        this.updateButtonState();
    }

    private void fileListChanged() {
        if (this.mFiles.size() > 0) {
            this.slider.setMaximum(this.mFiles.size() - 1);
            this.mIndex = this.slider.getMaximum();
            this.slider.setValue(this.mIndex);
        } else {
            this.slider.setMinimum(0);
            this.slider.setMaximum(0);
            this.slider.setValue(0);
            this.display(-1);
        }
        this.updateButtonState();
        this.slider.requestFocus();
    }

    private int getSpeedDelay() {
        return this.speedSlider.getMaximum() - this.speedSlider.getValue() + 50;
    }

    private void init() {
        int colVal = 51;
        this.label.setBackground(new Color(colVal, colVal, colVal, 196));
        this.label.setOpaque(true);
        this.label.setText("");
        this.previewLabel.setVisible(false);
        this.playPopupMenu.add((Component)this.speedSlider, 4);
        this.mPlayImageIcon = MaterialIcon._Av.PLAY_CIRCLE_OUTLINE.getImageIcon(54);
        this.mPauseImageIcon = MaterialIcon._Av.PAUSE_CIRCLE_OUTLINE.getImageIcon(54);
        this.mStartButton = DropDownButtonFactory.createDropDownButton((Icon)this.mPlayImageIcon, (JPopupMenu)this.playPopupMenu);
        this.mStartButton.setBorder(null);
        this.mStartButton.setBorderPainted(false);
        this.mStartButton.setFocusPainted(false);
        this.mStartButton.setFocusable(false);
        this.mStartButton.addActionListener(e -> this.playMenuItem.doClick());
        this.toolBar.add((Component)this.mStartButton, 1);
        this.mStartButton.setToolTipText(Dict.PLAY.toString());
        this.prevButton.setIcon(MaterialIcon._Av.SKIP_PREVIOUS.getImageIcon(36));
        this.nextButton.setIcon(MaterialIcon._Av.SKIP_NEXT.getImageIcon(36));
        this.updateButtonState();
        this.mTimer = new Timer(this.getSpeedDelay(), e -> {
            boolean shouldStop = false;
            if (this.reversedCheckBoxMenuItem.isSelected()) {
                if (this.slider.getValue() > 0) {
                    this.slider.setValue(this.slider.getValue() - 1);
                } else {
                    shouldStop = true;
                }
            } else if (this.slider.getValue() < this.slider.getMaximum()) {
                this.slider.setValue(this.slider.getValue() + 1);
            } else {
                shouldStop = true;
            }
            if (shouldStop) {
                this.mTimer.stop();
                this.mStartButton.setIcon(this.mPlayImageIcon);
            }
        });
        this.mTimer.setInitialDelay(this.getSpeedDelay());
    }

    private void initDropTarget() {
        this.mDropTarget = new DropTarget(){

            @Override
            public synchronized void drop(DropTargetDropEvent evt) {
                try {
                    evt.acceptDrop(1);
                    List droppedFiles = (List)evt.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    Collections.sort(droppedFiles);
                    File[] files = droppedFiles.toArray(new File[droppedFiles.size()]);
                    ImageViewPanel.this.addReplace(files);
                }
                catch (UnsupportedFlavorException | IOException exception) {
                    // empty catch block
                }
            }
        };
        this.imagePanel.setDropTarget(this.mDropTarget);
    }

    private void updateButtonState() {
        this.mStartButton.setEnabled(this.mFiles.size() > 1);
        SwingHelper.enableComponents((Container)this.playPopupMenu, (boolean)this.mStartButton.isEnabled(), (Component[])new Component[0]);
        this.speedMenuItem.setEnabled(false);
        this.prevButton.setEnabled(this.mIndex > 0);
        this.nextButton.setEnabled(this.mIndex < this.mFiles.size() - 1);
        this.slider.setEnabled(this.mFiles.size() > 1);
    }

    private void initComponents() {
        this.playPopupMenu = new JPopupMenu();
        this.playMenuItem = new JMenuItem();
        this.playAllMenuItem = new JMenuItem();
        this.reversedCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.speedMenuItem = new JMenuItem();
        this.speedSlider = new JSlider();
        this.previewLabel = new JLabel();
        this.imagePanel = new ImagePanel();
        this.label = new JLabel();
        this.controlPanel = new JPanel();
        this.toolBar = new JToolBar();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.toolbarSeparator1 = new JToolBar.Separator();
        this.slider = new JSlider();
        Mnemonics.setLocalizedText((AbstractButton)this.playMenuItem, (String)NbBundle.getMessage(ImageViewPanel.class, (String)"ImageViewPanel.playMenuItem.text"));
        this.playMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewPanel.this.playMenuItemActionPerformed(evt);
            }
        });
        this.playPopupMenu.add(this.playMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.playAllMenuItem, (String)NbBundle.getMessage(ImageViewPanel.class, (String)"ImageViewPanel.playAllMenuItem.text"));
        this.playAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewPanel.this.playAllMenuItemActionPerformed(evt);
            }
        });
        this.playPopupMenu.add(this.playAllMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.reversedCheckBoxMenuItem, (String)NbBundle.getMessage(ImageViewPanel.class, (String)"ImageViewPanel.reversedCheckBoxMenuItem.text"));
        this.playPopupMenu.add(this.reversedCheckBoxMenuItem);
        Mnemonics.setLocalizedText((AbstractButton)this.speedMenuItem, (String)NbBundle.getMessage(ImageViewPanel.class, (String)"ImageViewPanel.speedMenuItem.text"));
        this.speedMenuItem.setEnabled(false);
        this.playPopupMenu.add(this.speedMenuItem);
        this.speedSlider.setMaximum(2000);
        this.speedSlider.setValue(1700);
        this.speedSlider.setBorder(BorderFactory.createEmptyBorder(0, 16, 0, 16));
        this.speedSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImageViewPanel.this.speedSliderStateChanged(evt);
            }
        });
        this.setLayout(new BorderLayout());
        this.previewLabel.setBackground(new Color(102, 102, 102));
        this.previewLabel.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(ImageViewPanel.class, (String)"ImageViewPanel.previewLabel.text"));
        this.previewLabel.setEnabled(false);
        this.previewLabel.setOpaque(true);
        this.add((Component)this.previewLabel, "First");
        this.imagePanel.setBackground(new Color(102, 102, 102));
        this.label.setForeground(new Color(204, 204, 204));
        this.label.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)"jLabel1");
        GroupLayout imagePanelLayout = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.label, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(imagePanelLayout.createSequentialGroup().addComponent(this.label).addGap(0, 249, Short.MAX_VALUE)));
        this.add((Component)this.imagePanel, "Center");
        this.controlPanel.setLayout(new BorderLayout());
        this.toolBar.setFloatable(false);
        this.toolBar.setBorderPainted(false);
        this.prevButton.setToolTipText(Dict.PREVIOUS.toString());
        this.prevButton.setFocusable(false);
        this.prevButton.setHorizontalTextPosition(0);
        this.prevButton.setVerticalTextPosition(3);
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewPanel.this.prevButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.prevButton);
        this.nextButton.setToolTipText(Dict.NEXT.toString());
        this.nextButton.setFocusable(false);
        this.nextButton.setHorizontalTextPosition(0);
        this.nextButton.setVerticalTextPosition(3);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ImageViewPanel.this.nextButtonActionPerformed(evt);
            }
        });
        this.toolBar.add(this.nextButton);
        this.toolBar.add(this.toolbarSeparator1);
        this.controlPanel.add((Component)this.toolBar, "West");
        this.slider.setMaximum(0);
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ImageViewPanel.this.sliderStateChanged(evt);
            }
        });
        this.controlPanel.add((Component)this.slider, "Center");
        this.add((Component)this.controlPanel, "Last");
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        this.slider.setValue(this.slider.getValue() - 1);
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.slider.setValue(this.slider.getValue() + 1);
    }

    private void sliderStateChanged(ChangeEvent evt) {
        this.mIndex = this.slider.getValue();
        if (this.mFiles.size() > 0) {
            this.display(this.mIndex);
        }
    }

    private void playMenuItemActionPerformed(ActionEvent evt) {
        if (this.mTimer.isRunning()) {
            this.mTimer.stop();
            this.mStartButton.setIcon(this.mPlayImageIcon);
        } else {
            if (this.reversedCheckBoxMenuItem.isSelected() && this.slider.getValue() == 0) {
                this.slider.setValue(this.slider.getMaximum());
            } else if (!this.reversedCheckBoxMenuItem.isSelected() && this.slider.getValue() == this.slider.getMaximum()) {
                this.slider.setValue(0);
            }
            this.mTimer.start();
            this.mStartButton.setIcon(this.mPauseImageIcon);
        }
    }

    private void playAllMenuItemActionPerformed(ActionEvent evt) {
        if (this.reversedCheckBoxMenuItem.isSelected()) {
            this.slider.setValue(this.slider.getMaximum());
        } else {
            this.slider.setValue(0);
        }
        this.playMenuItem.doClick();
    }

    private void speedSliderStateChanged(ChangeEvent evt) {
        this.mTimer.setDelay(this.getSpeedDelay());
        this.mTimer.setInitialDelay(this.getSpeedDelay());
    }
}

