/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.swing;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class ANumericField
extends JTextField {
    private boolean selectedByMouse;

    public ANumericField() {
        this.init();
    }

    public ANumericField(int aValue) {
        this.init();
        this.setText(String.valueOf(aValue));
    }

    public ANumericField(double aValue) {
        this.init();
        this.setText(String.valueOf(aValue));
    }

    private ANumericField(String text) {
    }

    private ANumericField(String text, int columns) {
    }

    private ANumericField(Document doc, String text, int columns) {
    }

    public double getValue() throws NumberFormatException {
        return Double.parseDouble(this.getText().replace(",", "."));
    }

    private void init() {
        this.setHorizontalAlignment(11);
        this.setText("0");
        this.setDragEnabled(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                if (!ANumericField.this.isNumericInput(evt)) {
                    evt.consume();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent fe) {
                if (ANumericField.this.selectedByMouse) {
                    ANumericField.this.selectedByMouse = false;
                }
            }
        });
    }

    private boolean isNumericInput(KeyEvent evt) {
        boolean decimalSignTaken;
        char c = evt.getKeyChar();
        String text = ((JTextField)evt.getComponent()).getText();
        boolean isNumeric = false;
        boolean bl = decimalSignTaken = text.contains(".") || text.contains(",");
        if (Character.isDigit(c) || c == '.' || c == ',' || c == '\b' || c == '\u007f' || c == '-' && text.isEmpty()) {
            isNumeric = true;
            if ((c == '.' || c == ',') && decimalSignTaken) {
                isNumeric = false;
            }
        }
        return isNumeric;
    }
}

