/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.swing;

import java.awt.Component;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTabbedPane;
import se.trixon.almond.nbp.util.AString;

public class ATabbedPane
extends JTabbedPane {
    private int activeTabIndex;
    private String activeTabName;

    public ATabbedPane() {
    }

    public ATabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public ATabbedPane(int tabPlacement, int tabLayoutPolicy) {
        super(tabPlacement, tabLayoutPolicy);
    }

    public int getActiveTab() {
        return this.getModel().getSelectedIndex();
    }

    public void setTitleAt(Component c, String s) {
        int i = this.indexOfComponent(c);
        if (i > -1) {
            this.setTitleAt(i, s);
        }
    }

    public void recallActiveTabByIndex() {
        this.getModel().setSelectedIndex(this.activeTabIndex);
    }

    public void recallActiveTabByName() {
        this.getModel().setSelectedIndex(0);
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.activeTabName.equalsIgnoreCase(this.getComponentAt(i).getName())) continue;
            this.getModel().setSelectedIndex(i);
        }
    }

    public void rememberActiveTabByIndex() {
        this.activeTabIndex = this.getModel().getSelectedIndex();
    }

    public void rememberActiveTabByName() {
        this.activeTabName = this.getComponentAt(this.getModel().getSelectedIndex()).getName();
    }

    public void setTextAndMnemonic() {
        for (int i = 0; i < this.getTabCount(); ++i) {
            String text = this.getTitleAt(i);
            int mnemonicPosition = 0;
            this.setMnemonicAt(i, 0);
            Pattern p = Pattern.compile("&[^ ]");
            Matcher m = p.matcher(text);
            if (m.find()) {
                mnemonicPosition = m.start() + 1;
                char mnemonic = text.charAt(mnemonicPosition);
                this.setMnemonicAt(i, mnemonic);
                text = AString.removeCharAt(text, mnemonicPosition - 1);
            }
            this.setTitleAt(i, text);
        }
    }
}

