/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.swing;

import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import se.trixon.almond.util.GraphicsHelper;

public class ColorChooserButton
extends JButton {
    private static final String COLOR_SYMBOL = "\u2588";
    private Color mColor = Color.BLACK;
    private String mText;
    private Color mTextColor = Color.BLACK;

    public ColorChooserButton() {
        this.init();
    }

    public ColorChooserButton(String text) {
        super(text);
        this.init();
    }

    public ColorChooserButton(Action action) {
        super(action);
        this.init();
    }

    public ColorChooserButton(Icon icon) {
        super(icon);
        this.init();
    }

    public ColorChooserButton(String text, Icon icon) {
        super(text, icon);
        this.init();
    }

    public Color getColor() {
        return this.mColor;
    }

    public Color getTextColor() {
        return this.mTextColor;
    }

    public void setColor(Color color) {
        this.mColor = color;
        this.setText(this.mText);
    }

    @Override
    public void setText(String text) {
        this.mText = text;
        String color = GraphicsHelper.colorToHex((Color)this.mColor);
        String textColor = GraphicsHelper.colorToHex((Color)this.mTextColor);
        super.setText("<html><font color=%s>%s <font color=%s>%s</html>".formatted(color, COLOR_SYMBOL, textColor, text));
    }

    public void setTextColor(Color textColor) {
        this.mTextColor = textColor;
    }

    private void init() {
        this.setHorizontalAlignment(10);
    }
}

