/*
 * Decompiled with CFR 0.152.
 */
package se.trixon.almond.nbp.swing;

import java.text.NumberFormat;
import javax.swing.table.DefaultTableCellRenderer;

public class NumericTableCellRenderer
extends DefaultTableCellRenderer {
    private int fmFractionDigits;
    private Class mClass;

    public NumericTableCellRenderer() {
        this.setHorizontalAlignment(4);
    }

    public NumericTableCellRenderer(Class c, int fractionDigits) {
        this();
        this.mClass = c;
        this.fmFractionDigits = fractionDigits;
    }

    @Override
    public void setValue(Object value) {
        Object result = value;
        if (value != null && value instanceof Number) {
            NumberFormat formatter;
            Number numberValue = (Number)value;
            if (this.mClass == Double.class || this.mClass == Float.class) {
                formatter = NumberFormat.getNumberInstance();
                formatter.setMinimumFractionDigits(this.fmFractionDigits);
                formatter.setMaximumFractionDigits(this.fmFractionDigits);
            } else {
                formatter = NumberFormat.getIntegerInstance();
            }
            result = formatter.format(numberValue.doubleValue());
        }
        super.setValue(result);
    }
}

