/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.jts;

import com.github.filosganga.geogson.codec.Codec;
import com.github.filosganga.geogson.codec.CodecRegistry;
import com.github.filosganga.geogson.jts.GeometryCollectionCodec;
import com.github.filosganga.geogson.jts.LineStringCodec;
import com.github.filosganga.geogson.jts.LinearRingCodec;
import com.github.filosganga.geogson.jts.MultiLineStringCodec;
import com.github.filosganga.geogson.jts.MultiPointCodec;
import com.github.filosganga.geogson.jts.MultiPolygonCodec;
import com.github.filosganga.geogson.jts.PointCodec;
import com.github.filosganga.geogson.jts.PolygonCodec;
import com.github.filosganga.geogson.model.Geometry;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.IOException;

class JtsGeometryAdapter
extends TypeAdapter<com.vividsolutions.jts.geom.Geometry> {
    private final Gson gson;
    private final CodecRegistry<com.vividsolutions.jts.geom.Geometry, Geometry<?>> codecRegistry;

    public JtsGeometryAdapter(Gson gson, GeometryFactory geometryFactory) {
        this.gson = gson;
        this.codecRegistry = new CodecRegistry();
        this.codecRegistry.addCodec((Codec)new PointCodec(geometryFactory));
        this.codecRegistry.addCodec((Codec)new MultiPointCodec(geometryFactory));
        this.codecRegistry.addCodec((Codec)new LineStringCodec(geometryFactory));
        this.codecRegistry.addCodec((Codec)new LinearRingCodec(geometryFactory));
        this.codecRegistry.addCodec((Codec)new MultiLineStringCodec(geometryFactory));
        this.codecRegistry.addCodec((Codec)new PolygonCodec(geometryFactory));
        this.codecRegistry.addCodec((Codec)new MultiPolygonCodec(geometryFactory));
        this.codecRegistry.addCodec((Codec)new GeometryCollectionCodec(geometryFactory));
    }

    public void write(JsonWriter out, com.vividsolutions.jts.geom.Geometry value) throws IOException {
        if (value == null || value.getCoordinates().length == 0) {
            out.nullValue();
            return;
        }
        Geometry to = this.codecRegistry.toGeometry((Object)value);
        this.gson.getAdapter(new TypeToken<Geometry<?>>(){}).write(out, (Object)to);
    }

    public com.vividsolutions.jts.geom.Geometry read(JsonReader in) throws IOException {
        Geometry geometry = (Geometry)this.gson.getAdapter(new TypeToken<Geometry<?>>(){}).read(in);
        if (geometry == null) {
            return null;
        }
        return (com.vividsolutions.jts.geom.Geometry)this.codecRegistry.fromGeometry(geometry);
    }
}

