/*
 * Decompiled with CFR 0.152.
 */
package com.github.filosganga.geogson.jts;

import com.google.common.collect.UnmodifiableIterator;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;

class JtsPolygonIterable
implements Iterable<Polygon> {
    private final PolygonProvider src;

    private JtsPolygonIterable(PolygonProvider src) {
        this.src = src;
    }

    public static JtsPolygonIterable of(final MultiPolygon src) {
        return new JtsPolygonIterable(new PolygonProvider(){

            @Override
            public int getNumPolygons() {
                return src.getNumGeometries();
            }

            @Override
            public Polygon getPolygonN(int n) {
                return (Polygon)src.getGeometryN(n);
            }
        });
    }

    @Override
    public UnmodifiableIterator<Polygon> iterator() {
        return new Iterator(this.src);
    }

    private static interface PolygonProvider {
        public int getNumPolygons();

        public Polygon getPolygonN(int var1);
    }

    private static class Iterator
    extends UnmodifiableIterator<Polygon> {
        private final PolygonProvider src;
        private int index = 0;

        private Iterator(PolygonProvider src) {
            this.src = src;
        }

        public boolean hasNext() {
            return this.src.getNumPolygons() > this.index;
        }

        public Polygon next() {
            return this.src.getPolygonN(this.index++);
        }
    }
}

