/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.client.request;

import fr.dudie.nominatim.client.request.paramhelper.QueryParameter;
import fr.dudie.nominatim.client.request.paramhelper.ToStringSerializer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class QueryParameterAnnotationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryParameterAnnotationHandler.class);

    QueryParameterAnnotationHandler() {
    }

    static String process(Object o) {
        StringBuilder s = new StringBuilder();
        for (Field f : o.getClass().getDeclaredFields()) {
            QueryParameter paramMetadata = f.getAnnotation(QueryParameter.class);
            Object fieldValue = QueryParameterAnnotationHandler.getValue(o, f);
            if (null == fieldValue || null == paramMetadata) continue;
            String paramFormat = paramMetadata.value();
            String paramValue = QueryParameterAnnotationHandler.serialize(paramMetadata, fieldValue, f.getName());
            if (null == paramValue || "".equals(paramValue.trim())) continue;
            if (s.length() > 0) {
                s.append('&');
            }
            if (paramMetadata.encode()) {
                paramValue = QueryParameterAnnotationHandler.uriEncode(paramValue);
            }
            s.append(String.format(Locale.US, paramFormat, paramValue));
        }
        return s.toString();
    }

    private static String uriEncode(String paramValue) {
        try {
            return new URI(null, null, null, paramValue, null).getRawQuery();
        }
        catch (URISyntaxException e) {
            LOGGER.error("Failure encoding query parameter value {}", new Object[]{paramValue, e});
            return paramValue;
        }
    }

    private static String serialize(QueryParameter paramMetadata, Object fieldValue, String fieldName) {
        String paramValue;
        try {
            paramValue = paramMetadata.serializer().newInstance().handle(fieldValue);
        }
        catch (InstantiationException e) {
            LOGGER.error("Failure while serializing field {}", new Object[]{fieldName, e});
            paramValue = new ToStringSerializer().handle(fieldValue);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("Failure while serializing field {}", new Object[]{fieldName, e});
            paramValue = new ToStringSerializer().handle(fieldValue);
        }
        return paramValue;
    }

    private static Object getValue(Object o, Field f) {
        try {
            f.setAccessible(true);
            return f.get(o);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("failure accessing field value {}", new Object[]{f.getName(), e});
        }
        catch (IllegalAccessException e) {
            LOGGER.error("failure accessing field value {}", new Object[]{f.getName(), e});
        }
        return null;
    }
}

