/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import fr.dudie.nominatim.model.Element;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrayOfAddressElementsDeserializer
implements JsonDeserializer<Element[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayOfAddressElementsDeserializer.class);

    public Element[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        Element[] elements;
        if (json.isJsonObject()) {
            elements = new Element[json.getAsJsonObject().entrySet().size()];
            int i = 0;
            for (Map.Entry elem : json.getAsJsonObject().entrySet()) {
                elements[i] = new Element();
                elements[i].setKey((String)elem.getKey());
                elements[i].setValue(((JsonElement)elem.getValue()).getAsString());
                ++i;
            }
        } else {
            throw new JsonParseException("Unexpected data: " + json.toString());
        }
        return elements;
    }
}

