/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import fr.dudie.nominatim.model.PolygonPoint;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ArrayOfPolygonPointsDeserializer
implements JsonDeserializer<PolygonPoint[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayOfPolygonPointsDeserializer.class);

    public PolygonPoint[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        PolygonPoint[] points;
        if (json.isJsonArray()) {
            JsonArray pointsJsonArray = json.getAsJsonArray();
            points = new PolygonPoint[pointsJsonArray.size()];
            for (int i = 0; i < pointsJsonArray.size(); ++i) {
                points[i] = (PolygonPoint)context.deserialize(pointsJsonArray.get(i), PolygonPoint.class);
            }
        } else {
            throw new JsonParseException("Unexpected data: " + json.toString());
        }
        return points;
    }
}

