/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import fr.dudie.nominatim.model.BoundingBox;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BoundingBoxDeserializer
implements JsonDeserializer<BoundingBox> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BoundingBoxDeserializer.class);

    public BoundingBox deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (!json.isJsonArray()) {
            throw new JsonParseException("Unexpected data: " + json.toString());
        }
        JsonArray bboxJsonArray = json.getAsJsonArray();
        BoundingBox bbox = new BoundingBox();
        bbox.setSouth(bboxJsonArray.get(0).getAsDouble());
        bbox.setNorth(bboxJsonArray.get(1).getAsDouble());
        bbox.setWest(bboxJsonArray.get(2).getAsDouble());
        bbox.setEast(bboxJsonArray.get(3).getAsDouble());
        return bbox;
    }
}

