/*
 * Decompiled with CFR 0.152.
 */
package fr.dudie.nominatim.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import fr.dudie.nominatim.model.PolygonPoint;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PolygonPointDeserializer
implements JsonDeserializer<PolygonPoint> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolygonPointDeserializer.class);

    public PolygonPoint deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (!json.isJsonArray()) {
            throw new JsonParseException("Unexpected data: " + json.toString());
        }
        JsonArray pointsJsonArray = json.getAsJsonArray();
        PolygonPoint point = new PolygonPoint();
        point.setLongitude(pointsJsonArray.get(0).getAsDouble());
        point.setLatitude(pointsJsonArray.get(1).getAsDouble());
        return point;
    }
}

