/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import javafx.geometry.Point2D;
import org.apache.commons.lang3.StringUtils;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.mapton.api.MBounds;
import org.mapton.api.MCooTrans;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.openide.util.Exceptions;
import se.trixon.almond.util.Dict;

public class GeoToolsCooTrans
implements MCooTrans {
    private final String mCrsCode;
    private MathTransform mInverseMathTransform;
    private MathTransform mMathTransform;
    private MBounds mSourceBounds;
    private final CoordinateReferenceSystem mSourceCrs = DefaultGeographicCRS.WGS84;
    private MBounds mTargetBounds;
    private CoordinateReferenceSystem mTargetCrs;

    public GeoToolsCooTrans(String crsCode) {
        this.mCrsCode = crsCode;
        try {
            this.init(crsCode);
        }
        catch (FactoryException | NoninvertibleTransformException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (TransformException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    @Override
    public Point2D fromWgs84(double latitude, double longitude) {
        DirectPosition position = this.getPosition(this.mMathTransform, latitude, longitude);
        return new Point2D(position.getCoordinate()[1], position.getCoordinate()[0]);
    }

    @Override
    public MBounds getBoundsProjected() {
        return this.mTargetBounds;
    }

    @Override
    public MBounds getBoundsWgs84() {
        return this.mSourceBounds;
    }

    public String getCrsCode() {
        return this.mCrsCode;
    }

    public MathTransform getInverseMathTransform() {
        return this.mInverseMathTransform;
    }

    @Override
    public double getLatitude(double latitude, double longitude) {
        return this.getPosition(this.mMathTransform, latitude, longitude).getCoordinate()[0];
    }

    @Override
    public String getLatitudeString(double latitude, double longitude) {
        return "%.1f N".formatted(this.getLatitude(latitude, longitude));
    }

    @Override
    public double getLongitude(double latitude, double longitude) {
        return this.getPosition(this.mMathTransform, latitude, longitude).getCoordinate()[1];
    }

    @Override
    public String getLongitudeString(double latitude, double longitude) {
        return "%.1f E".formatted(this.getLongitude(latitude, longitude));
    }

    public MathTransform getMathTransform() {
        return this.mMathTransform;
    }

    @Override
    public String getName() {
        return StringUtils.removeStart((String)this.mTargetCrs.getName().toString(), (String)"EPSG:");
    }

    public CoordinateReferenceSystem getProjectedCrs() {
        return this.mTargetCrs;
    }

    @Override
    public String getString(double latitude, double longitude) {
        if (this.isWithinWgs84Bounds(latitude, longitude)) {
            return "%s  %s".formatted(this.getLatitudeString(latitude, longitude), this.getLongitudeString(latitude, longitude));
        }
        return Dict.OUT_OF_BOUNDS.toString();
    }

    @Override
    public boolean isWithinProjectedBounds(double latitude, double longitude) {
        return this.mTargetBounds.contains(longitude, latitude);
    }

    @Override
    public boolean isWithinWgs84Bounds(double latitude, double longitude) {
        return this.mSourceBounds.contains(longitude, latitude);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Point2D toWgs84(double latitude, double longitude) {
        DirectPosition position = this.getPosition(this.mInverseMathTransform, longitude, latitude);
        return new Point2D(position.getCoordinate()[0], position.getCoordinate()[1]);
    }

    private DirectPosition getPosition(MathTransform mMathTransform, double latitude, double longitude) {
        try {
            return mMathTransform.transform((DirectPosition)new DirectPosition2D(longitude, latitude), null);
        }
        catch (MismatchedDimensionException | TransformException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new DirectPosition2D();
        }
    }

    private void init(String crsCode) throws FactoryException, NoninvertibleTransformException, TransformException {
        this.mTargetCrs = CRS.decode((String)crsCode);
        this.mMathTransform = CRS.findMathTransform((CoordinateReferenceSystem)this.mSourceCrs, (CoordinateReferenceSystem)this.mTargetCrs, (boolean)true);
        this.mInverseMathTransform = this.mMathTransform.inverse();
        Envelope foreignEnvelope = CRS.getEnvelope((CoordinateReferenceSystem)this.mTargetCrs);
        org.locationtech.jts.geom.Envelope targetEnvelope = new org.locationtech.jts.geom.Envelope(foreignEnvelope.getLowerCorner().getCoordinate()[0], foreignEnvelope.getUpperCorner().getCoordinate()[0], foreignEnvelope.getLowerCorner().getCoordinate()[1], foreignEnvelope.getUpperCorner().getCoordinate()[1]);
        org.locationtech.jts.geom.Envelope sourceEnvelope = JTS.transform((org.locationtech.jts.geom.Envelope)targetEnvelope, (MathTransform)this.mInverseMathTransform);
        this.mSourceBounds = new MBounds(sourceEnvelope.getMinX(), sourceEnvelope.getMinY(), sourceEnvelope.getMaxX(), sourceEnvelope.getMaxY());
        this.mTargetBounds = new MBounds(targetEnvelope.getMinY(), targetEnvelope.getMinX(), targetEnvelope.getMaxY(), targetEnvelope.getMaxX());
    }
}

