/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import org.mapton.api.MChartLine;

public class LineChartX {
    private final MChartLine mChart;
    private LineChart<String, Number> mLineChart;
    private NumberAxis mNumberAxis;
    private XYChart.Series<String, Number>[] mSeries;
    private CategoryAxis mXAxis;

    public LineChartX(MChartLine chart) {
        this.mChart = chart;
        this.mXAxis = new CategoryAxis();
        this.mNumberAxis = new NumberAxis();
        this.mNumberAxis.setLabel(chart.getValueTitle());
        this.mLineChart = new LineChart((Axis)this.mXAxis, (Axis)this.mNumberAxis);
        this.mLineChart.setAxisSortingPolicy(LineChart.SortingPolicy.X_AXIS);
        this.mLineChart.setCreateSymbols(chart.isPlotSymbols());
        this.mLineChart.setAnimated(false);
        this.mXAxis.setStartMargin(0.0);
        this.mLineChart.setTitle(chart.getChartTitle());
        this.mSeries = new XYChart.Series[chart.getTitles().length];
        for (int i = 0; i < this.mSeries.length; ++i) {
            ObservableList data = FXCollections.observableArrayList();
            ObservableList<Number> values = chart.getValues()[i];
            for (int j = 0; j < values.size(); ++j) {
                Number n = (Number)values.get(j);
                data.add((Object)new XYChart.Data((Object)((String)chart.getColumns().get(j)), (Object)n));
            }
            this.mSeries[i] = new XYChart.Series(chart.getTitles()[i], data);
        }
        this.mLineChart.getData().setAll((Object[])this.mSeries);
    }

    public Node getNode() {
        return this.mLineChart;
    }
}

