/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.CheckBoxTreeItem;
import javafx.scene.control.TreeItem;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.CheckModel;
import org.controlsfx.control.CheckTreeView;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;
import org.mapton.api.MArea;
import org.mapton.api.MLatLon;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.fx.FxHelper;

public class MAreaFilterManager {
    private final Set<MArea> mAreaEnabledListenerSet;
    private final Map<String, CheckBoxTreeItem<MArea>> mAreaParents;
    private CheckModel<TreeItem<MArea>> mCheckModel;
    private final Preferences mExpandedPreferences;
    private final GeometryFactory mGeometryFactory = new GeometryFactory();
    private final ObjectProperty<ObservableList<MArea>> mItemsProperty = new SimpleObjectProperty();
    private CheckBoxTreeItem<MArea> mRootItem;
    private final ObjectProperty<TreeItem<MArea>> mSelectedObjectProperty = new SimpleObjectProperty();
    private final Set<CheckBoxTreeItem<MArea>> mTreeItemExpanderSet;
    private final Set<CheckBoxTreeItem<MArea>> mTreeItemListenerSet;
    private CheckTreeView<MArea> mTreeView;
    private final Preferences mVisibilityPreferences;
    private final WKTReader mWktReader = new WKTReader();

    public static MAreaFilterManager getInstance() {
        return Holder.INSTANCE;
    }

    private MAreaFilterManager() {
        this.mItemsProperty.setValue((Object)FXCollections.observableArrayList());
        this.mVisibilityPreferences = NbPreferences.forModule(MAreaFilterManager.class).node("area_visibility");
        this.mExpandedPreferences = NbPreferences.forModule(MAreaFilterManager.class).node("area_expanded");
        this.mAreaParents = new TreeMap<String, CheckBoxTreeItem<MArea>>();
        this.mAreaEnabledListenerSet = Collections.synchronizedSet(new HashSet());
        this.mTreeItemListenerSet = Collections.synchronizedSet(new HashSet());
        this.mTreeItemExpanderSet = Collections.synchronizedSet(new HashSet());
        this.createUI();
        this.initListeners();
        this.initBindings();
        this.populate();
    }

    public void addAll(ArrayList<MArea> areas) {
        for (MArea area : areas) {
            try {
                Geometry geometry = this.mWktReader.read(area.getWktGeometry());
                area.setGeometry(geometry);
            }
            catch (ParseException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.getItems().addAll(areas);
    }

    public ObservableList<TreeItem<MArea>> getCheckedItems() {
        return this.mCheckModel.getCheckedItems();
    }

    public final ObservableList<MArea> getItems() {
        return (ObservableList)this.mItemsProperty.get();
    }

    public CheckTreeView<MArea> getTreeView() {
        return this.mTreeView;
    }

    public boolean isValidCoordinate(Double lat, Double lon) {
        if (this.mCheckModel.getCheckedItems().isEmpty()) {
            return true;
        }
        Point point = this.mGeometryFactory.createPoint(new Coordinate(lon.doubleValue(), lat.doubleValue()));
        for (TreeItem checkedTreeItem : this.mCheckModel.getCheckedItems()) {
            Geometry areaGeometry;
            if (!checkedTreeItem.isLeaf() || !(areaGeometry = ((MArea)checkedTreeItem.getValue()).getGeometry()).contains((Geometry)point)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidCoordinate(MLatLon latLon) {
        return this.isValidCoordinate(latLon.getLatitude(), latLon.getLongitude());
    }

    public final ObjectProperty<ObservableList<MArea>> itemsProperty() {
        return this.mItemsProperty;
    }

    public ObjectProperty<TreeItem<MArea>> selectedObjectProperty() {
        return this.mSelectedObjectProperty;
    }

    private void createUI() {
        MArea rootArea = new MArea("");
        this.mRootItem = new CheckBoxTreeItem((Object)rootArea);
        this.mTreeView = new CheckTreeView(this.mRootItem);
        this.mCheckModel = this.mTreeView.getCheckModel();
        this.mTreeView.setShowRoot(false);
    }

    private String getCategory(MArea area) {
        return StringUtils.substringBeforeLast((String)area.getKey(), (String)"/");
    }

    private CheckBoxTreeItem<MArea> getParent(CheckBoxTreeItem<MArea> parent, String category) {
        String[] categorySegments = StringUtils.split((String)category, (String)"/");
        StringBuilder sb = new StringBuilder();
        for (String segment : categorySegments) {
            sb.append(segment);
            String path = sb.toString();
            if (this.mAreaParents.containsKey(path)) {
                parent = this.mAreaParents.get(path);
            } else {
                MArea area = new MArea(path);
                area.setName(segment);
                ObservableList observableList = parent.getChildren();
                parent = this.mAreaParents.computeIfAbsent(sb.toString(), k -> new CheckBoxTreeItem((Object)area));
                observableList.add((Object)parent);
            }
            sb.append("/");
        }
        return parent;
    }

    private String getPath(MArea area) {
        return "%s_%s".formatted(this.getCategory(area), area.getName());
    }

    private void initBindings() {
        this.mSelectedObjectProperty.bind((ObservableValue)this.mTreeView.getSelectionModel().selectedItemProperty());
    }

    private void initListeners() {
        this.getItems().addListener(c -> {
            while (c.next()) {
                FxHelper.runLater(() -> this.populate());
            }
        });
        this.mCheckModel.getCheckedItems().addListener(c -> {
            while (c.next()) {
                if (c.wasAdded()) {
                    c.getAddedSubList().forEach(treeItem -> {
                        if (treeItem.isLeaf() && !((MArea)treeItem.getValue()).isEnabled()) {
                            ((MArea)treeItem.getValue()).setEnabled(true);
                            this.mVisibilityPreferences.putBoolean(this.getPath((MArea)treeItem.getValue()), true);
                        }
                    });
                    continue;
                }
                if (!c.wasRemoved()) continue;
                c.getRemoved().forEach(treeItem -> {
                    if (treeItem.isLeaf() && ((MArea)treeItem.getValue()).isEnabled()) {
                        ((MArea)treeItem.getValue()).setEnabled(false);
                        this.mVisibilityPreferences.putBoolean(this.getPath((MArea)treeItem.getValue()), false);
                    }
                });
            }
        });
    }

    private void populate() {
        this.mRootItem.getChildren().clear();
        this.mTreeItemListenerSet.clear();
        TreeMap<String, CheckBoxTreeItem> areaParents = new TreeMap<String, CheckBoxTreeItem>();
        for (MArea area : this.getItems()) {
            boolean rootItem = StringUtils.containsNone((CharSequence)area.getKey(), (String)"/");
            if (rootItem) {
                area.setName(area.getKey());
            } else {
                area.setName(StringUtils.substringAfterLast((String)area.getKey(), (String)"/"));
            }
            CheckBoxTreeItem areaTreeItem = new CheckBoxTreeItem((Object)area);
            if (rootItem) {
                this.mRootItem.getChildren().add((Object)areaTreeItem);
                continue;
            }
            String category = this.getCategory(area);
            CheckBoxTreeItem parent = areaParents.computeIfAbsent(category, k -> this.getParent(this.mRootItem, category));
            parent.getChildren().add((Object)areaTreeItem);
        }
        this.mAreaParents.clear();
        this.mAreaParents.putAll(this.mAreaParents);
        this.postPopulate(this.mRootItem);
        this.mTreeItemExpanderSet.forEach(checkBoxTreeItem -> checkBoxTreeItem.setExpanded(true));
    }

    private void postPopulate(CheckBoxTreeItem<MArea> treeItem) {
        MArea area = (MArea)treeItem.getValue();
        if (treeItem.isLeaf()) {
            if (!this.mAreaEnabledListenerSet.contains(area)) {
                this.mAreaEnabledListenerSet.add(area);
            }
            if (this.mVisibilityPreferences.getBoolean(this.getPath(area), area.isEnabled())) {
                this.mCheckModel.check(treeItem);
                if (!area.isEnabled()) {
                    area.setEnabled(true);
                }
            } else {
                this.mCheckModel.clearCheck(treeItem);
                area.setEnabled(false);
            }
        } else {
            String path = this.getPath(area);
            if (this.mExpandedPreferences.getBoolean(path, false)) {
                this.mTreeItemExpanderSet.add(treeItem);
            }
            if (!this.mTreeItemListenerSet.contains(treeItem)) {
                treeItem.expandedProperty().addListener((observable, oldValue, newValue) -> this.mExpandedPreferences.putBoolean(path, (boolean)newValue));
                this.mTreeItemListenerSet.add(treeItem);
            }
            FXCollections.sort((ObservableList)treeItem.getChildren(), (o1, o2) -> ((MArea)o1.getValue()).getName().compareTo(((MArea)o2.getValue()).getName()));
            for (TreeItem childTreeItem : treeItem.getChildren()) {
                this.postPopulate((CheckBoxTreeItem<MArea>)((CheckBoxTreeItem)childTreeItem));
            }
        }
    }

    private static class Holder {
        private static final MAreaFilterManager INSTANCE = new MAreaFilterManager();

        private Holder() {
        }
    }
}

