/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.mapton.api.MSelectionLockManager;
import org.mapton.api.MTemporalManager;
import org.mapton.api.MTemporalRange;
import se.trixon.almond.util.fx.DelayedResetRunner;
import se.trixon.almond.util.fx.FxHelper;

public abstract class MBaseDataManager<T> {
    private static final Logger LOGGER = Logger.getLogger(MBaseDataManager.class.getName());
    protected final MSelectionLockManager mSelectionLockManager = MSelectionLockManager.getInstance();
    private final String TEMPORAL_PREFIX;
    private final ObjectProperty<ObservableList<T>> mAllItemsProperty = new SimpleObjectProperty();
    private final HashSet<T> mAllItemsSet = new HashSet();
    private final DelayedResetRunner mDelayedResetRunner;
    private final ObjectProperty<ObservableList<T>> mFilteredItemsProperty = new SimpleObjectProperty();
    private final HashSet<T> mFilteredItemsSet = new HashSet();
    private T mOldSelectedValue;
    private final ObjectProperty<T> mSelectedItemProperty = new SimpleObjectProperty();
    private final MTemporalManager mTemporalManager = MTemporalManager.getInstance();
    private final ObjectProperty<MTemporalRange> mTemporalRangeProperty = new SimpleObjectProperty();
    private final ObjectProperty<ObservableList<T>> mTimeFilteredItemsProperty = new SimpleObjectProperty();
    private final HashSet<T> mTimeFilteredItemsSet = new HashSet();
    private final DelayedResetRunner mUnlockDelayedResetRunner;

    public MBaseDataManager(Class<T> typeParameterClass) {
        this.TEMPORAL_PREFIX = typeParameterClass.getName();
        this.mAllItemsProperty.setValue((Object)FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList()));
        this.mFilteredItemsProperty.setValue((Object)FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList()));
        this.mTimeFilteredItemsProperty.setValue((Object)FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList()));
        this.mUnlockDelayedResetRunner = new DelayedResetRunner(100, () -> this.mSelectionLockManager.removeLock(this));
        this.mDelayedResetRunner = new DelayedResetRunner(50, () -> {
            try {
                this.selectionLock();
                this.applyTemporalFilter();
                this.selectionUnlock();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        this.init();
        this.initListeners();
    }

    public ObjectProperty<ObservableList<T>> allItemsProperty() {
        return this.mAllItemsProperty;
    }

    public ObjectProperty<ObservableList<T>> filteredItemsProperty() {
        return this.mFilteredItemsProperty;
    }

    public final ObservableList<T> getAllItems() {
        return (ObservableList)this.mAllItemsProperty.get();
    }

    public HashSet<T> getAllItemsSet() {
        return this.mAllItemsSet;
    }

    public ObservableList<T> getFilteredItems() {
        return (ObservableList)this.mFilteredItemsProperty.get();
    }

    public HashSet<T> getFilteredItemsSet() {
        return this.mFilteredItemsSet;
    }

    public T getSelectedItem() {
        return (T)this.mSelectedItemProperty.get();
    }

    public MTemporalRange getTemporalRange() {
        return (MTemporalRange)this.mTemporalRangeProperty.get();
    }

    public ObservableList<T> getTimeFilteredItems() {
        return (ObservableList)this.mTimeFilteredItemsProperty.get();
    }

    public HashSet<T> getTimeFilteredItemsSet() {
        return this.mTimeFilteredItemsSet;
    }

    public boolean isSelectionLocked() {
        return this.mSelectionLockManager.isLocked();
    }

    public boolean isSelectionUnlocked() {
        return !this.mSelectionLockManager.isLocked();
    }

    public boolean isValid(String string) {
        return string == null ? false : this.mTemporalManager.isValid(string);
    }

    public boolean isValid(LocalDate localDate) {
        return localDate == null ? false : this.mTemporalManager.isValid(localDate);
    }

    public boolean isValid(LocalDateTime localDateTime) {
        return localDateTime == null ? false : this.mTemporalManager.isValid(localDateTime);
    }

    public boolean isValid(Timestamp timestamp) {
        return timestamp == null ? false : this.mTemporalManager.isValid(timestamp);
    }

    public boolean isValid(java.sql.Date date) {
        return date == null ? false : this.mTemporalManager.isValid(date);
    }

    public boolean isValid(Date date) {
        return date == null ? false : this.mTemporalManager.isValid(date);
    }

    public void restoreSelection() {
        this.mSelectedItemProperty.set(this.mOldSelectedValue);
    }

    public ObjectProperty<T> selectedItemProperty() {
        return this.mSelectedItemProperty;
    }

    public void selectionLock() {
        this.mSelectionLockManager.addLock(this);
    }

    public void selectionUnlock() {
        this.mUnlockDelayedResetRunner.reset();
    }

    public void setSelectedItem(T item) {
        FxHelper.runLater(() -> this.mSelectedItemProperty.set(item));
    }

    public void setSelectedItemAfterReset(T item) {
        FxHelper.runLater(() -> {
            this.mSelectedItemProperty.set(null);
            FxHelper.runLaterDelayed(10L, () -> this.mSelectedItemProperty.set(item));
        });
    }

    public void setTemporalRange(LocalDate first, LocalDate last) {
        this.setTemporalRange(new MTemporalRange(first, last));
    }

    public void setTemporalRange(MTemporalRange temporalRange) {
        this.mTemporalManager.put(this.TEMPORAL_PREFIX, temporalRange);
        this.mTemporalRangeProperty.set((Object)temporalRange);
    }

    public void setTemporalVisibility(boolean visible) {
        if (this.mTemporalRangeProperty != null && this.getTemporalRange() != null) {
            if (visible && !this.mTemporalManager.contains(this.TEMPORAL_PREFIX)) {
                this.mTemporalManager.put(this.TEMPORAL_PREFIX, this.getTemporalRange());
                this.mTemporalManager.refresh();
            } else if (!visible && this.mTemporalManager.contains(this.TEMPORAL_PREFIX)) {
                this.mTemporalManager.remove(this.TEMPORAL_PREFIX);
                this.mTemporalManager.refresh();
            }
        }
    }

    public ObjectProperty<MTemporalRange> temporalRangeProperty() {
        return this.mTemporalRangeProperty;
    }

    public ObjectProperty<ObservableList<T>> timeFilteredItemsProperty() {
        return this.mTimeFilteredItemsProperty;
    }

    protected abstract void applyTemporalFilter();

    protected abstract void load(ArrayList<T> var1);

    private void init() {
    }

    private void initListeners() {
        this.mTemporalManager.lowDateProperty().addListener((observable, oldValue, newValue) -> this.mDelayedResetRunner.reset());
        this.mTemporalManager.highDateProperty().addListener((observable, oldValue, newValue) -> this.mDelayedResetRunner.reset());
        this.getFilteredItems().addListener(c -> this.mDelayedResetRunner.reset());
        this.mSelectedItemProperty.addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                this.mOldSelectedValue = newValue;
            }
        });
    }
}

