/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.healthmarketscience.sqlbuilder.BinaryCondition;
import com.healthmarketscience.sqlbuilder.ComboCondition;
import com.healthmarketscience.sqlbuilder.Condition;
import com.healthmarketscience.sqlbuilder.InsertQuery;
import com.healthmarketscience.sqlbuilder.OrderObject;
import com.healthmarketscience.sqlbuilder.SelectQuery;
import com.healthmarketscience.sqlbuilder.UpdateQuery;
import com.healthmarketscience.sqlbuilder.custom.postgresql.PgBinaryCondition;
import com.healthmarketscience.sqlbuilder.dbspec.Column;
import com.healthmarketscience.sqlbuilder.dbspec.Constraint;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import java.awt.Point;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.TreeSet;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.mapton.api.MBookmark;
import org.mapton.api.MLatLon;
import org.mapton.api.MLatLonBox;
import org.mapton.api.Mapton;
import org.mapton.api.db.DbBaseManager;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class MBookmarkManager
extends DbBaseManager {
    public static final String COL_CATEGORY = "category";
    public static final String COL_COLOR = "color";
    public static final String COL_CREATED = "created";
    public static final String COL_DESCRIPTION = "description";
    public static final String COL_DISPLAY_MARKER = "display_marker";
    public static final String COL_ID = "bookmark_id";
    public static final String COL_LATITUDE = "latitude";
    public static final String COL_LONGITUDE = "longitude";
    public static final String COL_MODIFIED = "modified";
    public static final String COL_NAME = "name";
    public static final String COL_URL = "url";
    public static final String COL_ZOOM = "zoom";
    private final ResourceBundle mBundle = NbBundle.getBundle(MBookmarkManager.class);
    private final DbColumn mCategory;
    private final DbColumn mColor;
    private final DbBaseManager.Columns mColumns = new DbBaseManager.Columns();
    private final DbColumn mDescription;
    private final DbColumn mDisplayMarker;
    private final ObjectProperty<ObservableList<MBookmark>> mItemsProperty = new SimpleObjectProperty();
    private final DbColumn mLatitude;
    private final DbColumn mLongitude;
    private final DbColumn mName;
    private String mStoredFilter = "";
    private final DbColumn mTimeCreated;
    private final DbColumn mTimeModified;
    private final DbColumn mUrl;
    private final DbColumn mZoom;

    public static MBookmarkManager getInstance() {
        return Holder.INSTANCE;
    }

    private MBookmarkManager() {
        this.mTable = this.getSchema().addTable("bookmark");
        this.mId = this.mTable.addColumn(COL_ID, "IDENTITY", null);
        this.mName = this.mTable.addColumn(COL_NAME, "VARCHAR", Integer.valueOf(0x100000));
        this.mCategory = this.mTable.addColumn(COL_CATEGORY, "VARCHAR", Integer.valueOf(0x100000));
        this.mDescription = this.mTable.addColumn(COL_DESCRIPTION, "VARCHAR", Integer.valueOf(0x100000));
        this.mUrl = this.mTable.addColumn(COL_URL, "VARCHAR", Integer.valueOf(0x100000));
        this.mColor = this.mTable.addColumn(COL_COLOR, "VARCHAR", Integer.valueOf(0x100000));
        this.mDisplayMarker = this.mTable.addColumn(COL_DISPLAY_MARKER, "BOOLEAN", null);
        this.mLatitude = this.mTable.addColumn(COL_LATITUDE, "DOUBLE", null);
        this.mLongitude = this.mTable.addColumn(COL_LONGITUDE, "DOUBLE", null);
        this.mZoom = this.mTable.addColumn(COL_ZOOM, "DOUBLE", null);
        this.mTimeCreated = this.mTable.addColumn(COL_CREATED, "TIMESTAMP", null);
        this.mTimeModified = this.mTable.addColumn(COL_MODIFIED, "TIMESTAMP", null);
        this.addNotNullConstraints(this.mName, this.mCategory, this.mDescription);
        this.create();
        this.mItemsProperty.setValue((Object)FXCollections.observableArrayList());
        this.addMissingColumns();
        this.dbLoad();
    }

    public DbBaseManager.Columns columns() {
        return this.mColumns;
    }

    @Override
    public void create() {
        String indexName = this.getIndexName(new DbColumn[]{this.mId}, "pkey");
        DbConstraint primaryKeyConstraint = new DbConstraint(this.mTable, indexName, Constraint.Type.PRIMARY_KEY, new DbColumn[]{this.mId});
        indexName = this.getIndexName(new DbColumn[]{this.mName, this.mCategory}, "key");
        DbConstraint uniqueKeyConstraint = new DbConstraint(this.mTable, indexName, Constraint.Type.UNIQUE, new DbColumn[]{this.mName, this.mCategory});
        this.mDb.create(this.mTable, false, primaryKeyConstraint, uniqueKeyConstraint);
    }

    public synchronized void dbDelete(MBookmark bookmark) throws ClassNotFoundException, SQLException {
        this.mDb.delete(this.mTable, this.mId, bookmark.getId());
        this.dbLoad();
    }

    public synchronized void dbDelete(String category) throws ClassNotFoundException, SQLException {
        for (MBookmark bookmark : (ObservableList)this.mItemsProperty.get()) {
            if (!StringUtils.startsWith((CharSequence)bookmark.getCategory(), (CharSequence)category)) continue;
            this.mDb.delete(this.mTable, this.mId, bookmark.getId());
        }
        this.dbLoad();
    }

    public synchronized void dbDelete() throws ClassNotFoundException, SQLException {
        for (MBookmark bookmark : (ObservableList)this.mItemsProperty.get()) {
            this.mDb.delete(this.mTable, this.mId, bookmark.getId());
        }
        this.dbLoad();
    }

    public synchronized void dbInsert(MBookmark bookmark) throws ClassNotFoundException, SQLException {
        this.dbInsertSilent(bookmark);
        this.dbLoad();
    }

    public synchronized Point dbInsert(ArrayList<MBookmark> bookmarks) {
        int imports = 0;
        int errors = 0;
        for (MBookmark bookmark : bookmarks) {
            try {
                this.dbInsertSilent(bookmark);
                ++imports;
            }
            catch (ClassNotFoundException | SQLException ex) {
                ++errors;
            }
        }
        Platform.runLater(() -> this.dbLoad());
        return new Point(imports, errors);
    }

    public synchronized ArrayList<MBookmark> dbLoad() {
        return this.dbLoad(this.mStoredFilter, true);
    }

    public synchronized ArrayList<MBookmark> dbLoad(String filter, boolean addToList) {
        if (this.mSelectPreparedStatement == null) {
            this.mSelectPlaceHolders.init(new Column[]{this.mCategory, this.mName, this.mDescription});
            ComboCondition comboCondition = ComboCondition.or((Condition[])new Condition[]{PgBinaryCondition.iLike((Object)this.mCategory, (Object)this.mSelectPlaceHolders.get(this.mCategory)), PgBinaryCondition.iLike((Object)this.mDescription, (Object)this.mSelectPlaceHolders.get(this.mDescription)), PgBinaryCondition.iLike((Object)this.mName, (Object)this.mSelectPlaceHolders.get(this.mName))});
            SelectQuery selectQuery = (SelectQuery)new SelectQuery().addAllTableColumns((Table)this.mTable).addOrderings(new Column[]{this.mCategory, this.mName, this.mDescription}).addCondition((Condition)comboCondition).validate();
            String sql = selectQuery.toString();
            try {
                this.mSelectPreparedStatement = this.mDb.getAutoCommitConnection().prepareStatement(sql);
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        ArrayList<MBookmark> bookmarks = new ArrayList<MBookmark>();
        try {
            this.mStoredFilter = filter;
            filter = this.getFilterPattern(filter);
            this.mSelectPlaceHolders.get(this.mCategory).setString(filter, this.mSelectPreparedStatement);
            this.mSelectPlaceHolders.get(this.mName).setString(filter, this.mSelectPreparedStatement);
            this.mSelectPlaceHolders.get(this.mDescription).setString(filter, this.mSelectPreparedStatement);
            ResultSet rs = this.mSelectPreparedStatement.executeQuery();
            rs.beforeFirst();
            while (rs.next()) {
                MBookmark bookmark = new MBookmark();
                bookmark.setId(this.getLong(rs, this.mId));
                bookmark.setName(this.getString(rs, this.mName));
                bookmark.setCategory(this.getString(rs, this.mCategory));
                bookmark.setDescription(this.getString(rs, this.mDescription));
                bookmark.setUrl(this.getString(rs, this.mUrl));
                bookmark.setColor(this.getString(rs, this.mColor));
                bookmark.setDisplayMarker(this.getBoolean(rs, this.mDisplayMarker));
                bookmark.setLatitude(this.getDouble(rs, this.mLatitude));
                bookmark.setLongitude(this.getDouble(rs, this.mLongitude));
                bookmark.setZoom(this.getDouble(rs, this.mZoom));
                bookmark.setTimeCreated(this.getTimestamp(rs, this.mTimeCreated));
                bookmark.setTimeModified(this.getTimestamp(rs, this.mTimeModified));
                bookmarks.add(bookmark);
            }
            if (addToList) {
                this.getItems().setAll(bookmarks);
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return bookmarks;
    }

    public synchronized void dbTruncate() throws ClassNotFoundException, SQLException {
        this.mDb.truncate(this.mTable);
        this.dbLoad();
    }

    public void dbUpdate(MBookmark bookmark) throws SQLException {
        if (this.mUpdatePreparedStatement == null) {
            this.mUpdatePlaceHolders.init(new Column[]{this.mId, this.mName, this.mCategory, this.mDescription, this.mUrl, this.mColor, this.mDisplayMarker, this.mLatitude, this.mLongitude, this.mZoom, this.mTimeModified});
            UpdateQuery updateQuery = (UpdateQuery)new UpdateQuery((Table)this.mTable).addCondition((Condition)BinaryCondition.equalTo((Object)this.mId, (Object)this.mUpdatePlaceHolders.get(this.mId))).addSetClause((Column)this.mName, (Object)this.mUpdatePlaceHolders.get(this.mName)).addSetClause((Column)this.mCategory, (Object)this.mUpdatePlaceHolders.get(this.mCategory)).addSetClause((Column)this.mDescription, (Object)this.mUpdatePlaceHolders.get(this.mDescription)).addSetClause((Column)this.mUrl, (Object)this.mUpdatePlaceHolders.get(this.mUrl)).addSetClause((Column)this.mColor, (Object)this.mUpdatePlaceHolders.get(this.mColor)).addSetClause((Column)this.mDisplayMarker, (Object)this.mUpdatePlaceHolders.get(this.mDisplayMarker)).addSetClause((Column)this.mLatitude, (Object)this.mUpdatePlaceHolders.get(this.mLatitude)).addSetClause((Column)this.mLongitude, (Object)this.mUpdatePlaceHolders.get(this.mLongitude)).addSetClause((Column)this.mZoom, (Object)this.mUpdatePlaceHolders.get(this.mZoom)).addSetClause((Column)this.mTimeModified, (Object)this.mUpdatePlaceHolders.get(this.mTimeModified)).validate();
            String sql = updateQuery.toString();
            this.mUpdatePreparedStatement = this.mDb.getAutoCommitConnection().prepareStatement(sql);
        }
        this.mUpdatePlaceHolders.get(this.mId).setLong(bookmark.getId(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mName).setString(bookmark.getName(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mCategory).setString(bookmark.getCategory(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mDescription).setString(bookmark.getDescription(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mUrl).setString(bookmark.getUrl(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mColor).setString(bookmark.getColor(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mDisplayMarker).setBoolean(bookmark.isDisplayMarker(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mLatitude).setObject((Object)bookmark.getLatitude(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mLongitude).setObject((Object)bookmark.getLongitude(), this.mUpdatePreparedStatement);
        this.mUpdatePlaceHolders.get(this.mZoom).setObject((Object)bookmark.getZoom(), this.mUpdatePreparedStatement);
        this.mUpdatePreparedStatement.setTimestamp(this.mUpdatePlaceHolders.get(this.mTimeModified).getIndex(), bookmark.getTimeModified());
        this.mUpdatePreparedStatement.executeUpdate();
    }

    public boolean exists(Object exceptForValue, String name, String category) {
        HashMap<DbColumn, Object> map = new HashMap<DbColumn, Object>();
        map.put(this.mName, name);
        map.put(this.mCategory, category);
        return this.exists(this.mId, exceptForValue, map);
    }

    public TreeSet<String> getCategories() {
        SelectQuery selectQuery = (SelectQuery)new SelectQuery().addFromTable((Table)this.mTable).addColumns(new Column[]{this.mCategory}).addOrdering((Column)this.mCategory, OrderObject.Dir.ASCENDING).addGroupings(new Column[]{this.mCategory}).validate();
        TreeSet<String> categories = new TreeSet<String>();
        categories.add("");
        try (Statement statement = this.mDb.getAutoCommitConnection().createStatement(1004, 1008);){
            String sql = selectQuery.toString();
            ResultSet rs = statement.executeQuery(sql);
            rs.beforeFirst();
            while (rs.next()) {
                categories.add(this.getString(rs, this.mCategory));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return categories;
    }

    public MLatLonBox getExtents(String category) {
        ArrayList<MLatLon> latLons = new ArrayList<MLatLon>();
        ((ObservableList)this.mItemsProperty.get()).stream().filter(bookmark -> StringUtils.startsWith((CharSequence)bookmark.getCategory(), (CharSequence)category)).forEachOrdered(bookmark -> latLons.add(new MLatLon(bookmark.getLatitude(), bookmark.getLongitude())));
        return new MLatLonBox(latLons);
    }

    public final ObservableList<MBookmark> getItems() {
        return (ObservableList)this.mItemsProperty.get();
    }

    public void goTo(MBookmark bookmark) throws ClassNotFoundException, SQLException {
        Mapton.getEngine().panTo(new MLatLon(bookmark.getLatitude(), bookmark.getLongitude()), bookmark.getZoom());
    }

    public final ObjectProperty<ObservableList<MBookmark>> itemsProperty() {
        return this.mItemsProperty;
    }

    private void addMissingColumns() {
        try {
            this.mDb.addMissingColumn(this.mTable.getAbsoluteName(), COL_COLOR, "VARCHAR(10)", COL_DESCRIPTION);
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void dbInsertSilent(MBookmark bookmark) throws ClassNotFoundException, SQLException {
        if (this.mInsertPreparedStatement == null) {
            this.mInsertPlaceHolders.init(new Column[]{this.mName, this.mCategory, this.mDescription, this.mUrl, this.mColor, this.mDisplayMarker, this.mLatitude, this.mLongitude, this.mZoom, this.mTimeCreated});
            InsertQuery insertQuery = (InsertQuery)new InsertQuery((Table)this.mTable).addColumn((Column)this.mName, (Object)this.mInsertPlaceHolders.get(this.mName)).addColumn((Column)this.mCategory, (Object)this.mInsertPlaceHolders.get(this.mCategory)).addColumn((Column)this.mDescription, (Object)this.mInsertPlaceHolders.get(this.mDescription)).addColumn((Column)this.mUrl, (Object)this.mInsertPlaceHolders.get(this.mUrl)).addColumn((Column)this.mColor, (Object)this.mInsertPlaceHolders.get(this.mColor)).addColumn((Column)this.mDisplayMarker, (Object)this.mInsertPlaceHolders.get(this.mDisplayMarker)).addColumn((Column)this.mLatitude, (Object)this.mInsertPlaceHolders.get(this.mLatitude)).addColumn((Column)this.mLongitude, (Object)this.mInsertPlaceHolders.get(this.mLongitude)).addColumn((Column)this.mZoom, (Object)this.mInsertPlaceHolders.get(this.mZoom)).addColumn((Column)this.mTimeCreated, (Object)this.mInsertPlaceHolders.get(this.mTimeCreated)).validate();
            String sql = insertQuery.toString();
            this.mInsertPreparedStatement = this.mDb.getAutoCommitConnection().prepareStatement(sql, 1);
        }
        this.mInsertPlaceHolders.get(this.mName).setString(bookmark.getName(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mCategory).setString(bookmark.getCategory(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mDescription).setString(bookmark.getDescription(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mUrl).setString(bookmark.getUrl(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mColor).setString(bookmark.getColor(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mDisplayMarker).setBoolean(bookmark.isDisplayMarker(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mLatitude).setObject((Object)bookmark.getLatitude(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mLongitude).setObject((Object)bookmark.getLongitude(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mZoom).setObject((Object)bookmark.getZoom(), this.mInsertPreparedStatement);
        this.mInsertPlaceHolders.get(this.mTimeCreated).setObject((Object)new Timestamp(System.currentTimeMillis()), this.mInsertPreparedStatement);
        int affectedRows = this.mInsertPreparedStatement.executeUpdate();
        if (affectedRows == 0) {
            Exceptions.printStackTrace((Throwable)new SQLException("Creating bookmark failed"));
        }
    }

    private void debugPrint() {
        System.out.println("debugPrint");
        for (MBookmark bookmark : this.getItems()) {
            System.out.println(ToStringBuilder.reflectionToString((Object)bookmark, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE));
        }
    }

    private static class Holder {
        private static final MBookmarkManager INSTANCE = new MBookmarkManager();

        private Holder() {
        }
    }
}

