/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.apache.commons.io.FileUtils;
import org.mapton.api.MCoordinateFile;
import org.mapton.api.MCoordinateFileOpener;
import org.mapton.api.MFileWatcher;
import org.mapton.api.MFileWatcherListener;
import org.mapton.api.Mapton;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import se.trixon.almond.util.fx.FxHelper;

public class MCoordinateFileManager {
    public static final String KEY_SOURCE_UPDATED = "files.source_updated";
    private File mConfigDir;
    private final MFileWatcher mFileWatcher = MFileWatcher.getInstance();
    private ObjectProperty<ObservableList<MCoordinateFile>> mItemsProperty = new SimpleObjectProperty();
    private File mSourcesFile;
    private final LongProperty mUpdatedProperty = new SimpleLongProperty();

    public static MCoordinateFileManager getInstance() {
        return Holder.INSTANCE;
    }

    private MCoordinateFileManager() {
        this.mItemsProperty.setValue((Object)FXCollections.observableArrayList());
        this.initListeners();
    }

    public boolean contains(MCoordinateFile coordinateFile) {
        return ((ObservableList)this.mItemsProperty.get()).stream().anyMatch(fileSource -> fileSource.getFile().equals(coordinateFile.getFile()));
    }

    public File getConfigDir() {
        if (this.mConfigDir == null) {
            this.mConfigDir = new File(Mapton.getConfigDir(), "files");
        }
        return this.mConfigDir;
    }

    public String[] getFileOpenerKeys() {
        ArrayList filterredFileOpeners = new ArrayList();
        Lookup.getDefault().lookupAll(MCoordinateFileOpener.class).stream().filter(coordinateFileOpener -> coordinateFileOpener.isUsedInFiles()).forEachOrdered(coordinateFileOpener -> filterredFileOpeners.add(coordinateFileOpener.getClass().getName()));
        return filterredFileOpeners.toArray(new String[0]);
    }

    public ObservableList<MCoordinateFile> getItems() {
        return (ObservableList)this.mItemsProperty.get();
    }

    public ArrayList<MCoordinateFile> getSublistBySupportedOpeners(Set<String> coordinateFileOpeners) {
        ArrayList<MCoordinateFile> coordinateFiles = new ArrayList<MCoordinateFile>();
        for (MCoordinateFile coordinateFile : (ObservableList)this.mItemsProperty.get()) {
            String opener = coordinateFile.getCoordinateFileOpenerName();
            if (!coordinateFileOpeners.contains(opener)) continue;
            coordinateFiles.add(coordinateFile);
        }
        return coordinateFiles;
    }

    public final ObjectProperty<ObservableList<MCoordinateFile>> itemsProperty() {
        if (this.mItemsProperty == null) {
            this.mItemsProperty = new SimpleObjectProperty((Object)this, "items");
        }
        return this.mItemsProperty;
    }

    public void load() {
        ArrayList loadedItems = new ArrayList();
        try {
            if (this.getSourcesFile().isFile()) {
                loadedItems = (ArrayList)Mapton.getGson().fromJson(FileUtils.readFileToString((File)this.getSourcesFile(), (String)"utf-8"), new TypeToken<ArrayList<MCoordinateFile>>(){}.getType());
                ArrayList<MCoordinateFile> invalidItems = new ArrayList<MCoordinateFile>();
                for (MCoordinateFile coordinateFile : loadedItems) {
                    if (coordinateFile.getFile().isFile()) continue;
                    invalidItems.add(coordinateFile);
                }
                loadedItems.removeAll(invalidItems);
            }
        }
        catch (JsonSyntaxException | IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        for (MCoordinateFile coordinateFile : loadedItems) {
            this.addWatcher(coordinateFile);
        }
        ArrayList items = loadedItems;
        Platform.runLater(() -> {
            ((ObservableList)this.mItemsProperty.get()).setAll((Collection)items);
            Mapton.getGlobalState().put(KEY_SOURCE_UPDATED, this);
        });
    }

    public void refresh() {
        long now = System.currentTimeMillis();
        if (this.mUpdatedProperty.get() != now) {
            this.mUpdatedProperty.set(now);
        }
    }

    public void removeAll(MCoordinateFile ... coordinateFiles) {
        FxHelper.runLater(() -> {
            try {
                if (coordinateFiles == null || coordinateFiles.length == 0) {
                    ((ObservableList)this.mItemsProperty.get()).clear();
                } else {
                    ((ObservableList)this.mItemsProperty.get()).removeAll((Object[])coordinateFiles);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    public void save() throws IOException {
        FileUtils.writeStringToFile((File)this.getSourcesFile(), (String)Mapton.getGson().toJson(this.mItemsProperty.get()), (String)"utf-8");
        this.refresh();
    }

    public void sort() {
        Comparator c1 = (o1, o2) -> o1.getFile().getName().toLowerCase(Locale.getDefault()).compareTo(o2.getFile().getName().toLowerCase(Locale.getDefault()));
        FXCollections.sort((ObservableList)((ObservableList)this.mItemsProperty.get()), (Comparator)c1);
    }

    public LongProperty updatedProperty() {
        return this.mUpdatedProperty;
    }

    private void addFiles(ArrayList<MCoordinateFile> coordinateFiles) {
        if (coordinateFiles != null) {
            for (MCoordinateFile coordinateFile : coordinateFiles) {
                this.addIfMissing(coordinateFile);
            }
        }
        this.sort();
    }

    private boolean addIfMissing(MCoordinateFile coordinateFile) {
        if (!this.contains(coordinateFile)) {
            this.getItems().add((Object)coordinateFile);
            this.addWatcher(coordinateFile);
            return true;
        }
        return false;
    }

    private void addWatcher(final MCoordinateFile coordinateFile) {
        this.mFileWatcher.addWatch(coordinateFile.getFile(), TimeUnit.SECONDS.toMillis(1L), new MFileWatcherListener(){

            @Override
            public void onFileChange(File file) {
                FxHelper.runLater(() -> {
                    ((ObservableList)MCoordinateFileManager.this.mItemsProperty.get()).removeAll((Object[])new MCoordinateFile[]{coordinateFile});
                    MCoordinateFileManager.this.addIfMissing(coordinateFile);
                    MCoordinateFileManager.this.sort();
                    MCoordinateFileManager.this.refresh();
                });
            }

            @Override
            public void onFileDelete(File file) {
                MCoordinateFileManager.this.removeAll(coordinateFile);
                MCoordinateFileManager.this.refresh();
            }
        });
    }

    private File getSourcesFile() {
        if (this.mSourcesFile == null) {
            this.mSourcesFile = new File(this.getConfigDir(), "sources.json");
        }
        return this.mSourcesFile;
    }

    private void initListeners() {
        Mapton.getGlobalState().addListener(gsce -> FxHelper.runLater(() -> this.addFiles((ArrayList)gsce.getValue())), this.getFileOpenerKeys());
    }

    private static class Holder {
        private static final MCoordinateFileManager INSTANCE = new MCoordinateFileManager();

        private Holder() {
        }
    }
}

