/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MAttribution;
import org.mapton.api.MDataSource;
import org.mapton.api.MWmsSource;
import org.mapton.api.MWmsSourceProvider;
import org.mapton.api.MWmsStyle;
import org.mapton.api.MWmsStyleProvider;
import org.mapton.api.Mapton;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public class MDataSourceInitializer
implements Runnable {
    private static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    static final Gson gson = new GsonBuilder().disableHtmlEscaping().setVersion(1.0).setPrettyPrinting().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    private static final String LOG_TAG = "DataSources";
    private final Preferences mPreferences = NbPreferences.forModule(MDataSourceInitializer.class);

    public MDataSourceInitializer() {
        this.mPreferences.addPreferenceChangeListener(evt -> {
            switch (evt.getKey()) {
                case "data_sources.files": {
                    this.applyFile();
                    break;
                }
                case "data_sources.wms.sources": {
                    this.applyWmsSource();
                    break;
                }
                case "data_sources.wms.styles": {
                    this.applyWmsStyle();
                }
            }
        });
        Lookup.getDefault().lookupResult(MWmsSourceProvider.class).addLookupListener(lookupEvent -> this.applyWmsSource());
        Lookup.getDefault().lookupResult(MWmsStyleProvider.class).addLookupListener(lookupEvent -> this.applyWmsStyle());
    }

    @Override
    public void run() {
        this.applyWmsSource();
        this.applyWmsStyle();
        this.applyFile();
    }

    private void applyFile() {
        ArrayList<File> files = new ArrayList<File>();
        for (String line : this.mPreferences.get("data_sources.files", "").split("\n")) {
            File file = new File(line);
            if (!file.exists()) continue;
            files.add(file);
        }
        Mapton.getGlobalState().put("data_sources.files", files);
    }

    private void applyWmsSource() {
        ArrayList allSources = new ArrayList();
        for (String json : this.getJsons(this.mPreferences.get("data_sources.wms.sources", MDataSource.getDefaultSources()))) {
            try {
                this.deserializeSource(json).stream().filter(wmsSource -> wmsSource.isEnabled()).forEachOrdered(wmsSource -> allSources.add(wmsSource));
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (JsonSyntaxException ex) {
                Mapton.getLog().i(LOG_TAG, ex.toString());
            }
        }
        for (MWmsSourceProvider wmsSourceProvider : Lookup.getDefault().lookupAll(MWmsSourceProvider.class)) {
            try {
                this.deserializeSource(wmsSourceProvider.getJson()).stream().filter(wmsSource -> wmsSource.isEnabled()).forEachOrdered(wmsSource -> allSources.add(wmsSource));
            }
            catch (NullPointerException ex) {
            }
            catch (JsonSyntaxException ex) {
                Mapton.getLog().i(LOG_TAG, ex.toString());
            }
        }
        Mapton.getGlobalState().put("data_sources.wms.sources", allSources);
        TreeMap<String, MAttribution> attributions = new TreeMap<String, MAttribution>();
        for (MWmsSource wmsSource2 : allSources) {
            attributions.putAll(wmsSource2.getAttributions());
        }
        Mapton.getGlobalState().put("data_sources.wms.attributions", attributions);
    }

    private void applyWmsStyle() {
        ArrayList allStyles = new ArrayList();
        for (String json : this.getJsons(this.mPreferences.get("data_sources.wms.styles", MDataSource.getDefaultStyles()))) {
            try {
                this.deserializeStyle(json).stream().filter(wmsStyle -> wmsStyle.isEnabled()).forEachOrdered(wmsStyle -> allStyles.add(wmsStyle));
            }
            catch (JsonSyntaxException | NullPointerException ex) {
                Mapton.getLog().i(LOG_TAG, ex.toString());
            }
        }
        for (MWmsStyleProvider wmsStyleProvider : Lookup.getDefault().lookupAll(MWmsStyleProvider.class)) {
            try {
                this.deserializeStyle(wmsStyleProvider.getJson()).stream().filter(wmsStyle -> wmsStyle.isEnabled()).forEachOrdered(wmsStyle -> allStyles.add(wmsStyle));
            }
            catch (JsonSyntaxException ex) {
                Mapton.getLog().i(LOG_TAG, ex.toString());
            }
        }
        Mapton.getGlobalState().put("data_sources.wms.styles", allStyles);
    }

    private ArrayList<MWmsSource> deserializeSource(String json) {
        return (ArrayList)gson.fromJson(json, new TypeToken<ArrayList<MWmsSource>>(){}.getType());
    }

    private ArrayList<MWmsStyle> deserializeStyle(String json) {
        return (ArrayList)gson.fromJson(json, new TypeToken<ArrayList<MWmsStyle>>(){}.getType());
    }

    private ArrayList<String> getJsons(String lines) {
        ArrayList<String> jsons = new ArrayList<String>();
        for (String line : lines.split("\n")) {
            if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
            String json = "";
            try {
                if (line.contains("//")) {
                    json = IOUtils.toString((URI)new URI(line), (String)"utf-8");
                } else {
                    File file = new File(line);
                    json = FileUtils.readFileToString((File)file, (String)"utf-8");
                }
            }
            catch (IOException | URISyntaxException ex) {
                Mapton.getLog().i(LOG_TAG, ex.toString());
            }
            jsons.add(json);
        }
        return jsons;
    }
}

