/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import de.micromata.opengis.kml.v_2_2_0.AltitudeMode;
import de.micromata.opengis.kml.v_2_2_0.BalloonStyle;
import de.micromata.opengis.kml.v_2_2_0.Boundary;
import de.micromata.opengis.kml.v_2_2_0.ColorMode;
import de.micromata.opengis.kml.v_2_2_0.Coordinate;
import de.micromata.opengis.kml.v_2_2_0.Document;
import de.micromata.opengis.kml.v_2_2_0.Feature;
import de.micromata.opengis.kml.v_2_2_0.Folder;
import de.micromata.opengis.kml.v_2_2_0.Icon;
import de.micromata.opengis.kml.v_2_2_0.IconStyle;
import de.micromata.opengis.kml.v_2_2_0.Kml;
import de.micromata.opengis.kml.v_2_2_0.KmlFactory;
import de.micromata.opengis.kml.v_2_2_0.LineString;
import de.micromata.opengis.kml.v_2_2_0.LineStyle;
import de.micromata.opengis.kml.v_2_2_0.LinearRing;
import de.micromata.opengis.kml.v_2_2_0.Placemark;
import de.micromata.opengis.kml.v_2_2_0.PolyStyle;
import de.micromata.opengis.kml.v_2_2_0.Polygon;
import de.micromata.opengis.kml.v_2_2_0.Style;
import de.micromata.opengis.kml.v_2_2_0.Vec2;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javafx.geometry.Point3D;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.mapton.api.MLatLon;
import se.trixon.almond.util.ext.GrahamScan;

public abstract class MKmlCreator {
    protected static final Logger LOGGER = Logger.getLogger(MKmlCreator.class.getName());
    protected final Document mDocument;
    protected final Kml mKml = new Kml();
    protected Folder mRootFolder;
    protected final FastDateFormat mTimeStampDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssX");

    public static Comparator<Feature> getFeatureNameComparator() {
        return (o1, o2) -> o1.getName().compareTo(o2.getName());
    }

    public MKmlCreator() {
        this.mDocument = this.mKml.createAndSetDocument().withOpen(Boolean.valueOf(true));
    }

    public Placemark addCircle0(String name, ArrayList<Coordinate> coordinates, Folder folder) {
        try {
            Placemark placemark = folder.createAndAddPlacemark().withName(name);
            Style style = placemark.createAndAddStyle();
            LineStyle lineStyle = style.createAndSetLineStyle().withColor("00000000").withWidth(0.0);
            PolyStyle polyStyle = style.createAndSetPolyStyle().withColor("ccffffff").withColorMode(ColorMode.RANDOM);
            Polygon polygon = placemark.createAndSetPolygon();
            Boundary boundary = polygon.createAndSetOuterBoundaryIs();
            LinearRing linearRing = boundary.createAndSetLinearRing();
            coordinates.forEach(node -> linearRing.addToCoordinates(node.getLongitude(), node.getLatitude()));
            return placemark;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.err.println(e);
            return null;
        }
    }

    public void addConvexHullPolygon(String name, ArrayList<Coordinate> coordinates, Folder polygonFolder, String color, ColorMode colorMode) {
        ArrayList<Point2D.Double> inputs = new ArrayList<Point2D.Double>();
        coordinates.forEach(coordinate -> inputs.add(new Point2D.Double(coordinate.getLongitude(), coordinate.getLatitude())));
        try {
            List<Point2D.Double> convexHull = GrahamScan.getConvexHullDouble(inputs);
            Placemark placemark = polygonFolder.createAndAddPlacemark().withName(name);
            Style style = placemark.createAndAddStyle();
            LineStyle lineStyle = style.createAndSetLineStyle().withColor("00000000").withWidth(0.0);
            PolyStyle polyStyle = style.createAndSetPolyStyle();
            if (color != null) {
                polyStyle.setColor(color);
            }
            if (colorMode != null) {
                polyStyle.setColorMode(colorMode);
            }
            Polygon polygon = placemark.createAndSetPolygon();
            Boundary boundary = polygon.createAndSetOuterBoundaryIs();
            LinearRing linearRing = boundary.createAndSetLinearRing();
            convexHull.forEach(node -> linearRing.addToCoordinates(node.x, node.y));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.err.println(e);
        }
    }

    public Placemark createCircle(String name, ArrayList<Point3D> coordinates, String color) {
        try {
            Placemark placemark = KmlFactory.createPlacemark().withName(name);
            Style style = placemark.createAndAddStyle();
            if (color != null) {
                LineStyle lineStyle = style.createAndSetLineStyle().withColor(color).withWidth(0.0);
                PolyStyle polyStyle = style.createAndSetPolyStyle().withColor(color).withFill(Boolean.valueOf(true)).withColorMode(ColorMode.NORMAL);
            }
            Polygon polygon = placemark.createAndSetPolygon();
            Boundary boundary = polygon.createAndSetOuterBoundaryIs();
            LinearRing linearRing = boundary.createAndSetLinearRing();
            coordinates.forEach(node -> linearRing.addToCoordinates(node.getX(), node.getY()));
            return placemark;
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            System.err.println(e);
            return null;
        }
    }

    @Deprecated
    public ArrayList<Point3D> createCircle(double lat, double lon, double radius, int quality) {
        if (quality < 3) {
            throw new IllegalArgumentException("Quality must be greater than 2");
        }
        ArrayList<Point3D> list = new ArrayList<Point3D>();
        for (double phi = 0.0; phi < Math.PI * 2; phi += Math.PI * 2 / (double)quality) {
            double lat2 = Math.sin(phi);
            double lon2 = Math.cos(phi);
            list.add(new Point3D(lon + lon2 * radius, lat + lat2 * radius, 0.0));
        }
        list.add((Point3D)list.get(0));
        return list;
    }

    public Placemark createCircle(String name, double lat, double lon, double radius, int quality, double width, String lineColor, String fillColor, ColorMode colorMode, AltitudeMode altitudeMode) {
        if (quality < 3) {
            throw new IllegalArgumentException("Quality must be greater than 2");
        }
        MLatLon center = new MLatLon(lat, lon);
        ArrayList<Point3D> list = new ArrayList<Point3D>();
        for (double i = 0.0; i < 360.0; i += 360.0 / (double)quality) {
            MLatLon latLon = center.getDestinationPoint(i, radius);
            list.add(new Point3D(latLon.getLongitude(), latLon.getLatitude(), 0.0));
        }
        list.add((Point3D)list.get(0));
        return this.createPolygon(name, list, width, lineColor, fillColor, colorMode, altitudeMode);
    }

    public Placemark createLine(String name, ArrayList<Point3D> coordinates, double width, String color, AltitudeMode altitudeMode) {
        Placemark placemark = KmlFactory.createPlacemark().withName(name);
        Style style = placemark.createAndAddStyle();
        LineStyle lineStyle = style.createAndSetLineStyle().withWidth(width);
        if (color != null) {
            lineStyle.setColor(color);
        }
        LineString line = placemark.createAndSetLineString();
        for (Point3D coordinate : coordinates) {
            line.addToCoordinates(coordinate.getX(), coordinate.getY(), coordinate.getZ());
        }
        line.setAltitudeMode(altitudeMode);
        return placemark;
    }

    public Placemark createLine(String name, Point3D p1, Point3D p2, double width, String color, AltitudeMode altitudeMode) {
        ArrayList<Point3D> coordinates = new ArrayList<Point3D>();
        coordinates.add(p1);
        coordinates.add(p2);
        return this.createLine(name, coordinates, width, color, altitudeMode);
    }

    public Placemark createPlacemark(String name, double lat, double lon, double scale, String color, String href, Vec2 hotSpot, BalloonStyle balloonStyle) {
        Placemark placemark = KmlFactory.createPlacemark().withName(name);
        if (href != null) {
            Style style = placemark.createAndAddStyle();
            IconStyle iconStyle = style.createAndSetIconStyle().withScale(scale);
            if (color != null) {
                iconStyle.setColor(color);
            }
            if (balloonStyle != null) {
                style.setBalloonStyle(balloonStyle);
            }
            if (hotSpot != null) {
                iconStyle.setHotSpot(hotSpot);
            }
            Icon icon = KmlFactory.createIcon().withHref(href);
            iconStyle.setIcon(icon);
        }
        placemark.createAndSetPoint().addToCoordinates(lon, lat);
        return placemark;
    }

    public Placemark createPolygon(String name, ArrayList<Point3D> coordinates, double width, String lineColor, String fillColor, ColorMode colorMode, AltitudeMode altitudeMode) {
        Placemark placemark = KmlFactory.createPlacemark().withName(name);
        Style style = placemark.createAndAddStyle();
        LineStyle lineStyle = style.createAndSetLineStyle().withColor(lineColor).withWidth(width);
        PolyStyle polyStyle = style.createAndSetPolyStyle();
        if (fillColor != null) {
            polyStyle.setColor(fillColor);
        }
        if (colorMode != null) {
            polyStyle.setColorMode(colorMode);
        }
        Polygon polygon = placemark.createAndSetPolygon();
        Boundary boundary = polygon.createAndSetOuterBoundaryIs();
        LinearRing linearRing = boundary.createAndSetLinearRing();
        coordinates.forEach(node -> linearRing.addToCoordinates(node.getX(), node.getY()));
        polygon.setAltitudeMode(altitudeMode);
        return placemark;
    }

    public String save(File f) throws IOException {
        return this.save(f, false, false);
    }

    public String save(File f, boolean cleanNS2, boolean cleanSpace) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.mKml.marshal((Writer)stringWriter);
        String kmlString = stringWriter.toString();
        if (cleanNS2) {
            kmlString = this.cleanNS2(kmlString);
        }
        if (cleanSpace) {
            kmlString = this.cleanSpace(kmlString);
        }
        FileUtils.writeStringToFile((File)f, (String)kmlString, (String)"utf-8");
        return kmlString;
    }

    public void setVisible(Feature feature, boolean visible) {
        feature.setVisibility(Boolean.valueOf(visible));
        if (feature instanceof Folder) {
            Folder folder = (Folder)feature;
            folder.getFeature().forEach(f -> this.setVisible((Feature)f, visible));
        }
    }

    public void sort(Comparator<Feature> c, List<Feature> features) {
        for (Feature feature : features) {
            this.sort(c, feature);
        }
    }

    public void sort(Comparator<Feature> c, Feature ... features) {
        for (Feature feature : features) {
            if (!(feature instanceof Folder)) continue;
            Folder folder = (Folder)feature;
            List subFeatures = folder.getFeature();
            subFeatures.sort(c);
            subFeatures.forEach(f -> this.sort(c, (Feature)f));
        }
    }

    protected String getSafeXmlString(String s) {
        if (StringUtils.containsAny((CharSequence)s, (char[])new char[]{'<', '>', '&'})) {
            s = "<![CDATA[" + s + "]]>";
        }
        return s;
    }

    private String cleanNS2(String kmlString) {
        kmlString = StringUtils.replace((String)kmlString, (String)"xmlns:ns2=", (String)"xmlns=");
        kmlString = StringUtils.replace((String)kmlString, (String)"<ns2:", (String)"<");
        kmlString = StringUtils.replace((String)kmlString, (String)"</ns2:", (String)"</");
        return kmlString;
    }

    private String cleanSpace(String kmlString) {
        kmlString = StringUtils.replace((String)kmlString, (String)"        ", (String)"\t");
        kmlString = StringUtils.replace((String)kmlString, (String)"    ", (String)"\t");
        return kmlString;
    }
}

