/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import org.mapton.api.MLatLon;

public class MLatLonBox {
    @SerializedName(value="northEast")
    private MLatLon mNorthEast;
    @SerializedName(value="southWest")
    private MLatLon mSouthWest;

    public MLatLonBox() {
    }

    public MLatLonBox(MLatLon southWest, MLatLon northEast) {
        this.mSouthWest = southWest;
        this.mNorthEast = northEast;
    }

    public MLatLonBox(ArrayList<MLatLon> latLons) {
        double north = Double.MIN_VALUE;
        double east = Double.MIN_VALUE;
        double south = Double.MAX_VALUE;
        double west = Double.MAX_VALUE;
        for (MLatLon latLon : latLons) {
            north = Math.max(latLon.getLatitude() + 90.0, north);
            east = Math.max(latLon.getLongitude() + 180.0, east);
            south = Math.min(latLon.getLatitude(), south);
            west = Math.min(latLon.getLongitude(), west);
        }
        this.mSouthWest = new MLatLon(south, west);
        this.mNorthEast = new MLatLon(north - 90.0, east - 180.0);
    }

    public MLatLon getCenter() {
        return new MLatLon(this.mSouthWest.getLatitude() + 0.5 * (this.mNorthEast.getLatitude() - this.mSouthWest.getLatitude()), this.mSouthWest.getLongitude() + 0.5 * (this.mNorthEast.getLongitude() - this.mSouthWest.getLongitude()));
    }

    public double getLatitudeSpan() {
        return this.getNorthEast().getLatitude() - this.getSouthWest().getLatitude();
    }

    public double getLongitudeSpan() {
        return this.getNorthEast().getLongitude() - this.getSouthWest().getLongitude();
    }

    public MLatLon getNorthEast() {
        return this.mNorthEast;
    }

    public MLatLon getSouthWest() {
        return this.mSouthWest;
    }

    public void setNorthEast(MLatLon northEast) {
        this.mNorthEast = northEast;
    }

    public void setSouthWest(MLatLon southWest) {
        this.mSouthWest = southWest;
    }

    public String toString() {
        return "sw: (%s), ne: (%s)".formatted(this.mSouthWest.toString(), this.mNorthEast.toString());
    }
}

