/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.paint.Color;
import org.mapton.api.MCooTrans;
import org.mapton.api.MCrsManager;
import org.mapton.api.MEngine;
import org.mapton.api.MLatLon;
import org.mapton.api.Mapton;
import org.openide.util.NbPreferences;
import se.trixon.almond.util.OptionsBase;
import se.trixon.almond.util.fx.FxHelper;

public class MOptions
extends OptionsBase {
    public static final String DEFAULT_UI_LAF_ICON_COLOR_BRIGHT = "D3D3D3";
    public static final String DEFAULT_UI_LAF_ICON_COLOR_DARK = "1A1A1A";
    public static final String KEY_COPY_LOCATION_COORDINATE_SEPARATOR = "copyLocation.coordinateSeparator";
    public static final String KEY_COPY_LOCATION_DECIMAL_SYMBOL = "copyLocation.decimalSymbol";
    public static final String KEY_GRID_GLOBAL_CLAMP_TO_GROUND = "global_clamp_to_ground";
    public static final String KEY_GRID_GLOBAL_EQUATOR = "grid.global.equator";
    public static final String KEY_GRID_GLOBAL_LATITUDES = "grid.global.latitudes";
    public static final String KEY_GRID_GLOBAL_LONGITUDES = "grid.global.longitudes";
    public static final String KEY_GRID_GLOBAL_PLOT = "grid.global.plot";
    public static final String KEY_GRID_GLOBAL_POLAR_ANTARCTIC = "grid.global.polar_antarctic";
    public static final String KEY_GRID_GLOBAL_POLAR_ARCTIC = "grid.global.polar_arctic";
    public static final String KEY_GRID_GLOBAL_TROPIC_CANCER = "grid.global.tropic_cancer";
    public static final String KEY_GRID_GLOBAL_TROPIC_CAPRICORN = "grid.global.tropic_capricorn";
    public static final String KEY_GRID_LOCAL_PLOT = "grid.local.plot";
    public static final String KEY_LOCAL_GRIDS = "local_grids";
    public static final String KEY_MAP_DISPLAY_CROSSHAIR = "map.display.crosshair";
    public static final String KEY_MAP_DISPLAY_HOME_ICON = "map.display.homeicon";
    public static final String KEY_MAP_ENGINE = "map.engine";
    public static final String KEY_MAP_HOME_LAT = "map.home_lat";
    public static final String KEY_MAP_HOME_LON = "map.home_lon";
    public static final String KEY_MAP_ONLY = "map_only";
    public static final String KEY_UI_LAF_DARK = "ui.laf.dark";
    public static final String KEY_UI_LAF_ICON_COLOR_BRIGHT = "ui.laf.icon_color_bright";
    public static final String KEY_UI_LAF_ICON_COLOR_DARK = "ui.laf.icon_color_dark";
    public static final String KEY_UI_POPOVER = "ui.popover";
    private static final String DEFAULT_COPY_LOCATION_COORDINATE_SEPARATOR = ",";
    private static final String DEFAULT_COPY_LOCATION_DECIMAL_SYMBOL = ".";
    private static final boolean DEFAULT_MAP_DISPLAY_CROSSHAIR = true;
    private static final boolean DEFAULT_MAP_DISPLAY_HOME_ICON = false;
    private static final String DEFAULT_MAP_ENGINE = "WorldWind";
    private static final double DEFAULT_MAP_LAT = 57.55736;
    private static final double DEFAULT_MAP_LON = 12.539189;
    private static final boolean DEFAULT_MAP_ONLY = false;
    private static final double DEFAULT_MAP_ZOOM = (double)0.7f;
    private static final boolean DEFAULT_UI_LAF_NIGHT_MODE = true;
    private static final boolean DEFAULT_UI_POPOVER = false;
    private static final String KEY_MAP_CENTER_LAT = "map.center_lat";
    private static final String KEY_MAP_CENTER_LON = "map.center_lon";
    private static final String KEY_MAP_COO_TRANS = "map.coo_trans";
    private static final String KEY_MAP_HOME_ZOOM = "map.home_zoom";
    private static final String KEY_MAP_ZOOM = "map.zoom";
    private final StringProperty mCoordinateSeparatorProperty = new SimpleStringProperty(",");
    private final StringProperty mDecimalSymbolProperty = new SimpleStringProperty(".");
    private final BooleanProperty mDisplayCrosshairProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty mDisplayHomeIconProperty = new SimpleBooleanProperty(false);
    private final ObjectProperty<String> mEngineInternalProperty = new SimpleObjectProperty();
    private final ObjectProperty<String> mEngineProperty = new SimpleObjectProperty((Object)"WorldWind");
    private final ObjectProperty<Color> mIconColorBrightProperty = new SimpleObjectProperty((Object)Color.valueOf((String)"D3D3D3"));
    private final ObjectProperty<Color> mIconColorDarkProperty = new SimpleObjectProperty((Object)Color.valueOf((String)"1A1A1A"));
    private final BooleanProperty mMaximizedMapProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty mNightModeProperty = new SimpleBooleanProperty(true);
    private final BooleanProperty mPreferPopoverProperty = new SimpleBooleanProperty(true);

    public static MOptions getInstance() {
        return Holder.INSTANCE;
    }

    private MOptions() {
        this.setPreferences(NbPreferences.forModule(MOptions.class));
        this.initListeners();
        this.load();
    }

    public StringProperty coordinateSeparatorProperty() {
        return this.mCoordinateSeparatorProperty;
    }

    public StringProperty decimalSymbolProperty() {
        return this.mDecimalSymbolProperty;
    }

    public BooleanProperty displayCrosshairProperty() {
        return this.mDisplayCrosshairProperty;
    }

    public BooleanProperty displayHomeIconProperty() {
        return this.mDisplayHomeIconProperty;
    }

    public ObjectProperty<String> engineInternalProperty() {
        return this.mEngineInternalProperty;
    }

    public ObjectProperty<String> engineProperty() {
        return this.mEngineProperty;
    }

    public String getCoordinateSeparator() {
        return (String)this.mCoordinateSeparatorProperty.get();
    }

    public String getDecimalSymbol() {
        return (String)this.mDecimalSymbolProperty.get();
    }

    public String getEngine() {
        return (String)this.mEngineProperty.get();
    }

    public Color getIconColor() {
        if (this.is(KEY_UI_LAF_DARK, new boolean[0])) {
            return this.getIconColorBright();
        }
        return this.getIconColorDark();
    }

    public Color getIconColorBright() {
        return (Color)this.mIconColorBrightProperty.getValue();
    }

    public Color getIconColorDark() {
        return (Color)this.mIconColorDarkProperty.getValue();
    }

    public Color getIconColorForBackground() {
        return this.mNightModeProperty.get() ? (Color)this.mIconColorBrightProperty.getValue() : (Color)this.mIconColorDarkProperty.getValue();
    }

    public MLatLon getMapCenter() {
        return new MLatLon(this.mPreferences.getDouble(KEY_MAP_CENTER_LAT, 57.55736), this.mPreferences.getDouble(KEY_MAP_CENTER_LON, 12.539189));
    }

    public MCooTrans getMapCooTrans() {
        ObservableList<MCooTrans> items = MCrsManager.getInstance().getItems();
        for (MCooTrans cooTrans : items) {
            if (!cooTrans.getName().equalsIgnoreCase(this.getMapCooTransName())) continue;
            return cooTrans;
        }
        MCooTrans cooTrans = (MCooTrans)items.get(0);
        this.setMapCooTrans(cooTrans.getName());
        return cooTrans;
    }

    public String getMapCooTransName() {
        return this.mPreferences.get(KEY_MAP_COO_TRANS, "WGS 84 DMS");
    }

    public MLatLon getMapHome() {
        return new MLatLon(this.mPreferences.getDouble(KEY_MAP_HOME_LAT, 57.55736), this.mPreferences.getDouble(KEY_MAP_HOME_LON, 12.539189));
    }

    public double getMapHomeZoom() {
        return this.mPreferences.getDouble(KEY_MAP_HOME_ZOOM, 0.7f);
    }

    public double getMapZoom() {
        return this.mPreferences.getDouble(KEY_MAP_ZOOM, 0.7f);
    }

    public ObjectProperty<Color> iconColorBrightProperty() {
        return this.mIconColorBrightProperty;
    }

    public ObjectProperty<Color> iconColorDarkProperty() {
        return this.mIconColorDarkProperty;
    }

    public boolean isDisplayCrosshair() {
        return this.mDisplayCrosshairProperty.get();
    }

    public boolean isDisplayHomeIcon() {
        return this.mDisplayHomeIconProperty.get();
    }

    public boolean isFirstRun() {
        return this.mPreferences.getBoolean("app.first_run", true);
    }

    public boolean isFullscreen() {
        return this.mPreferences.getBoolean("fullscreen", false);
    }

    public boolean isMapOnly() {
        return this.mPreferences.getBoolean(KEY_MAP_ONLY, false);
    }

    public boolean isMaximizedMap() {
        return this.mMaximizedMapProperty.get();
    }

    public boolean isNightMode() {
        return this.mNightModeProperty.get();
    }

    public boolean isPreferPopover() {
        return this.mPreferPopoverProperty.get();
    }

    public BooleanProperty maximizedMapProperty() {
        return this.mMaximizedMapProperty;
    }

    public BooleanProperty nightModeProperty() {
        return this.mNightModeProperty;
    }

    public BooleanProperty preferPopoverProperty() {
        return this.mPreferPopoverProperty;
    }

    public void setFullscreen(boolean value) {
        this.mPreferences.putBoolean("fullscreen", value);
    }

    public void setMapCenter(MLatLon value) {
        this.mPreferences.putDouble(KEY_MAP_CENTER_LAT, value.getLatitude());
        this.mPreferences.putDouble(KEY_MAP_CENTER_LON, value.getLongitude());
    }

    public void setMapCooTrans(String value) {
        this.mPreferences.put(KEY_MAP_COO_TRANS, value);
    }

    public void setMapHome(MLatLon value) {
        this.mPreferences.putDouble(KEY_MAP_HOME_LAT, value.getLatitude());
        this.mPreferences.putDouble(KEY_MAP_HOME_LON, value.getLongitude());
    }

    public void setMapHomeZoom(double value) {
        this.mPreferences.putDouble(KEY_MAP_HOME_ZOOM, value);
    }

    public void setMapOnly(boolean value) {
        this.mPreferences.putBoolean(KEY_MAP_ONLY, value);
    }

    public void setMapZoom(double value) {
        this.mPreferences.putDouble(KEY_MAP_ZOOM, value);
    }

    private void initListeners() {
        this.mPreferences.addPreferenceChangeListener(pcl -> {
            switch (pcl.getKey()) {
                case "ui.popover": {
                    this.mPreferPopoverProperty.set(this.is(KEY_UI_POPOVER, new boolean[0]));
                }
            }
        });
        this.mNightModeProperty.addListener((ov, t, t1) -> this.put(KEY_UI_LAF_DARK, (boolean)t1));
        this.mPreferPopoverProperty.addListener((ov, t, t1) -> this.put(KEY_UI_POPOVER, (boolean)t1));
        this.mDisplayCrosshairProperty.addListener((ov, t, t1) -> this.put(KEY_MAP_DISPLAY_CROSSHAIR, (boolean)t1));
        this.mDisplayHomeIconProperty.addListener((ov, t, t1) -> this.put(KEY_MAP_DISPLAY_HOME_ICON, (boolean)t1));
        this.mEngineInternalProperty.addListener((ov, t, t1) -> {
            MEngine oldEngine = Mapton.getEngine();
            try {
                oldEngine.onDeactivate();
                this.setMapZoom(oldEngine.getZoom());
                this.setMapCenter(oldEngine.getCenter());
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            this.put(KEY_MAP_ENGINE, (String)t1);
            this.mEngineProperty.set(t1);
        });
        this.mIconColorBrightProperty.addListener((ov, t, t1) -> this.put(KEY_UI_LAF_ICON_COLOR_BRIGHT, FxHelper.colorToHexRGB(t1)));
        this.mIconColorDarkProperty.addListener((ov, t, t1) -> this.put(KEY_UI_LAF_ICON_COLOR_DARK, FxHelper.colorToHexRGB(t1)));
        this.mCoordinateSeparatorProperty.addListener((ov, t, t1) -> this.put(KEY_COPY_LOCATION_COORDINATE_SEPARATOR, (String)t1));
        this.mDecimalSymbolProperty.addListener((ov, t, t1) -> this.put(KEY_COPY_LOCATION_DECIMAL_SYMBOL, (String)t1));
    }

    private void load() {
        this.mPreferPopoverProperty.setValue(Boolean.valueOf(this.is(KEY_UI_POPOVER, false)));
        this.mNightModeProperty.setValue(Boolean.valueOf(this.is(KEY_UI_LAF_DARK, true)));
        this.mDisplayCrosshairProperty.setValue(Boolean.valueOf(this.is(KEY_MAP_DISPLAY_CROSSHAIR, true)));
        this.mDisplayHomeIconProperty.setValue(Boolean.valueOf(this.is(KEY_MAP_DISPLAY_HOME_ICON, false)));
        this.mEngineProperty.set((Object)this.get(KEY_MAP_ENGINE, DEFAULT_MAP_ENGINE));
        this.mIconColorDarkProperty.set((Object)FxHelper.colorFromHexRGBA(this.get(KEY_UI_LAF_ICON_COLOR_DARK, DEFAULT_UI_LAF_ICON_COLOR_DARK)));
        this.mIconColorBrightProperty.set((Object)FxHelper.colorFromHexRGBA(this.get(KEY_UI_LAF_ICON_COLOR_BRIGHT, DEFAULT_UI_LAF_ICON_COLOR_BRIGHT)));
        this.mCoordinateSeparatorProperty.set((Object)this.get(KEY_COPY_LOCATION_COORDINATE_SEPARATOR, DEFAULT_COPY_LOCATION_COORDINATE_SEPARATOR));
        this.mDecimalSymbolProperty.set((Object)this.get(KEY_COPY_LOCATION_DECIMAL_SYMBOL, DEFAULT_COPY_LOCATION_DECIMAL_SYMBOL));
    }

    private static class Holder {
        private static final MOptions INSTANCE = new MOptions();

        private Holder() {
        }
    }
}

