/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.TreeSet;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.paint.Color;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MAreaFilterManager;
import org.mapton.api.MBackgroundImage;
import org.mapton.api.MBaseDataManager;
import org.mapton.api.MBookmark;
import org.mapton.api.MBookmarkManager;
import org.mapton.api.MGenericLoader;
import org.mapton.api.MPoi;
import org.mapton.api.MPoiProvider;
import org.mapton.api.MPolygonFilterManager;
import org.mapton.api.Mapton;
import org.openide.util.Lookup;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.StringHelper;
import se.trixon.almond.util.fx.DelayedResetRunner;

public class MPoiManager
extends MBaseDataManager<MPoi> {
    private final MAreaFilterManager mAreaFilterManager = MAreaFilterManager.getInstance();
    private final ObjectProperty<TreeSet<String>> mCategoriesProperty = new SimpleObjectProperty();
    private DelayedResetRunner mDelayedResetRunner;
    private String mFilter = "";
    private final MPolygonFilterManager mPolygonFilterManager = MPolygonFilterManager.getInstance();
    private final BooleanProperty mPolygonFilterProperty = new SimpleBooleanProperty(false);
    private final SimpleObjectProperty<Long> mTrigRefreshCategoriesProperty = new SimpleObjectProperty();

    public static MPoiManager getInstance() {
        return Holder.INSTANCE;
    }

    private MPoiManager() {
        super(MPoi.class);
        this.mCategoriesProperty.set(new TreeSet());
        this.initListeners();
        this.mDelayedResetRunner.reset();
    }

    public ObjectProperty<TreeSet<String>> categoriesProperty() {
        return this.mCategoriesProperty;
    }

    public BooleanProperty polygonFilterProperty() {
        return this.mPolygonFilterProperty;
    }

    public void refresh() {
        this.refresh(this.mFilter);
    }

    public void refresh(String filter) {
        this.mFilter = filter;
        this.mDelayedResetRunner.reset();
    }

    public SimpleObjectProperty<Long> trigRefreshCategoriesProperty() {
        return this.mTrigRefreshCategoriesProperty;
    }

    @Override
    protected void applyTemporalFilter() {
        this.getTimeFilteredItems().setAll(this.getFilteredItems());
    }

    @Override
    protected void load(ArrayList<MPoi> items) {
    }

    private void applyFilter() {
        ArrayList<MPoi> filteredPois = new ArrayList<MPoi>();
        this.getAllItems().stream().filter(poi -> this.validPoi((MPoi)poi, this.mFilter)).forEachOrdered(poi -> filteredPois.add((MPoi)poi));
        Comparator<MPoi> comparator = Comparator.comparing(MPoi::getProvider).thenComparing(Comparator.comparing(MBookmark::getCategory)).thenComparing(Comparator.comparing(MBookmark::getName));
        filteredPois.sort(comparator);
        this.getFilteredItems().setAll(filteredPois);
    }

    private void initListeners() {
        this.mDelayedResetRunner = new DelayedResetRunner(200, () -> {
            ArrayList allPois = new ArrayList();
            Lookup.getDefault().lookupAll(MPoiProvider.class).forEach(poiProvider -> {
                try {
                    for (MPoi poi : poiProvider.getPois()) {
                        poi.setCategory((String)StringUtils.defaultIfBlank((CharSequence)poi.getCategory(), (CharSequence)"_DEFAULT"));
                        poi.setProvider(poiProvider.getName());
                        poi.setZoom(poi.getZoom() != null ? poi.getZoom() : 0.9);
                        allPois.add(poi);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to load POI from " + poiProvider.getName());
                }
            });
            this.getAllItems().setAll(allPois);
            this.mTrigRefreshCategoriesProperty.set((Object)System.currentTimeMillis());
        });
        Lookup.getDefault().lookupResult(MPoiProvider.class).addLookupListener(lookupEvent -> this.mDelayedResetRunner.reset());
        this.mCategoriesProperty.addListener((observable, oldValue, newValue) -> this.applyFilter());
        this.selectedItemProperty().addListener((observable, oldValue, newValue) -> this.sendObjectProperties((MPoi)newValue));
        MBookmarkManager.getInstance().getItems().addListener(c -> this.refresh());
        this.mPolygonFilterManager.addListener(() -> this.refresh());
        this.mAreaFilterManager.getCheckedItems().addListener(c -> this.refresh());
    }

    private void sendObjectProperties(MPoi poi) {
        Object propertyPresenter = null;
        if (poi != null) {
            if (poi.getPropertyNode() != null) {
                propertyPresenter = poi.getPropertyNode();
                if (propertyPresenter instanceof MGenericLoader) {
                    MGenericLoader genericLoader = (MGenericLoader)propertyPresenter;
                    genericLoader.load(poi.getPropertySource());
                }
            } else {
                LinkedHashMap<Object, Object> propertyMap = new LinkedHashMap();
                if (poi.getPropertyMap() != null) {
                    propertyMap = poi.getPropertyMap();
                } else {
                    Mapton.getGlobalState().put("background_image", new MBackgroundImage(poi.getExternalImageUrl(), 0.95));
                    propertyMap.put(Dict.NAME.toString(), poi.getName());
                    propertyMap.put(Dict.CATEGORY.toString(), poi.getCategory());
                    propertyMap.put(Dict.SOURCE.toString(), poi.getProvider());
                    propertyMap.put(Dict.DESCRIPTION.toString(), poi.getDescription());
                    propertyMap.put(Dict.TAGS.toString(), poi.getTags());
                    propertyMap.put(Dict.COLOR.toString(), Color.web((String)poi.getColor()));
                    propertyMap.put("URL", poi.getUrl());
                }
                propertyPresenter = propertyMap;
            }
        }
        Mapton.getGlobalState().put("object.properties", propertyPresenter);
    }

    private boolean validPoi(MPoi poi, String filter) {
        String category = "%s/%s".formatted(poi.getProvider(), poi.getCategory());
        boolean valid = ((TreeSet)this.mCategoriesProperty.get()).contains(category) && ObjectUtils.allNotNull((Object[])new Object[]{poi.getLatitude(), poi.getLongitude()}) && (StringHelper.matchesSimpleGlob(poi.getProvider(), filter, true, true) || StringHelper.matchesSimpleGlob(poi.getUrl(), filter, true, true) || StringHelper.matchesSimpleGlob(poi.getName(), filter, true, true) || StringHelper.matchesSimpleGlob(poi.getCategory(), filter, true, true) || StringHelper.matchesSimpleGlob(poi.getGroup(), filter, true, true) || StringHelper.matchesSimpleGlob(poi.getDescription(), filter, true, true));
        boolean validAreaCoordinate = this.mAreaFilterManager.isValidCoordinate(poi.getLatitude(), poi.getLongitude());
        boolean validRulerCoordinate = !this.mPolygonFilterManager.hasItems() || !this.mPolygonFilterProperty.get() || this.mPolygonFilterProperty.get() && this.mPolygonFilterManager.contains(poi.getLatitude(), poi.getLongitude());
        return valid && validAreaCoordinate && validRulerCoordinate;
    }

    private static class Holder {
        private static final MPoiManager INSTANCE = new MPoiManager();

        private Holder() {
        }
    }
}

