/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.util.Calendar;
import org.apache.commons.lang3.time.FastDateFormat;
import org.mapton.api.Mapton;
import se.trixon.almond.util.GlobalState;

public class MPrint {
    private FastDateFormat mDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH.mm.ss.SSS: ");
    private final GlobalState mGlobalState = Mapton.getGlobalState();
    private final String mKey;
    private boolean mUseTimestamps = true;

    public MPrint(String key) {
        this.mKey = key;
    }

    public void err(String x) {
        this.mGlobalState.put(this.mKey, this.getDatedString("* " + x));
    }

    public void err(Object x) {
        if (x == null) {
            this.err("NULL");
        } else {
            this.err(String.valueOf(x));
        }
    }

    public boolean isUseTimestamps() {
        return this.mUseTimestamps;
    }

    public void out(String x) {
        this.mGlobalState.put(this.mKey, this.getDatedString(x));
    }

    public void out(Object x) {
        if (x == null) {
            this.out("NULL");
        } else {
            this.out(String.valueOf(x));
        }
    }

    public void setDateFormat(FastDateFormat dateFormat) {
        this.mDateFormat = dateFormat;
    }

    public void setUseTimestamps(boolean useTimestamps) {
        this.mUseTimestamps = useTimestamps;
    }

    private String getDatedString(String s) {
        if (this.mUseTimestamps) {
            return this.mDateFormat.format(Calendar.getInstance().getTime()) + s;
        }
        return s;
    }
}

