/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.openide.util.Exceptions;

public class MSelectionLockManager {
    public static long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(5L);
    private static final Logger LOGGER = Logger.getLogger(MSelectionLockManager.class.getName());
    private final Set<Object> mLocks = Collections.synchronizedSet(new HashSet());
    private final HashSet<MObjectSelectionLockListener> mObjectSelectionLockListeners = new HashSet();

    public static MSelectionLockManager getInstance() {
        return Holder.INSTANCE;
    }

    private MSelectionLockManager() {
    }

    public boolean addListener(MObjectSelectionLockListener objectSelectionLockListener) {
        return this.mObjectSelectionLockListeners.add(objectSelectionLockListener);
    }

    public void addLock(Object lockObject) {
        this.addLock(lockObject, DEFAULT_TIMEOUT);
    }

    public void addLock(Object lockObject, long timeout) {
        boolean wasUnlocked = this.mLocks.isEmpty();
        if (this.mLocks.contains(lockObject)) {
            return;
        }
        this.mLocks.add(lockObject);
        if (wasUnlocked) {
            this.mObjectSelectionLockListeners.forEach(objectSelectionLockListener -> {
                try {
                    objectSelectionLockListener.onLocked();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (timeout > 0L) {
            new Thread(() -> {
                try {
                    Thread.sleep(DEFAULT_TIMEOUT);
                    if (this.mLocks.contains(lockObject)) {
                        this.removeLock(lockObject);
                    }
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    Thread.currentThread().interrupt();
                }
            }, this.getClass().getCanonicalName()).start();
        }
    }

    public boolean isLocked() {
        return !this.mLocks.isEmpty();
    }

    public void printLocks() {
        StringBuilder sb = new StringBuilder();
        this.mLocks.forEach(lock -> sb.append(lock).append("\n"));
        LOGGER.info(sb.toString());
    }

    public boolean removeListener(MObjectSelectionLockListener objectSelectionLockListener) {
        return this.mObjectSelectionLockListeners.remove(objectSelectionLockListener);
    }

    public void removeLock(Object lockObject) {
        boolean wasLocked;
        boolean bl = wasLocked = !this.mLocks.isEmpty();
        if (!this.mLocks.contains(lockObject)) {
            return;
        }
        this.mLocks.remove(lockObject);
        if (wasLocked && this.mLocks.isEmpty()) {
            this.mObjectSelectionLockListeners.forEach(objectSelectionLockListener -> {
                try {
                    objectSelectionLockListener.onUnlocked();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    public void removeLock(Object lockObject, long delay) {
        new Thread(() -> {
            try {
                Thread.sleep(delay);
                this.removeLock(lockObject);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                Thread.currentThread().interrupt();
            }
        }, this.getClass().getCanonicalName()).start();
    }

    private static class Holder {
        private static final MSelectionLockManager INSTANCE = new MSelectionLockManager();

        private Holder() {
        }
    }

    public static interface MObjectSelectionLockListener {
        public void onLocked();

        public void onUnlocked();
    }
}

