/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MSimpleObjectStorage;
import org.mapton.api.MSimpleObjectStorageBoolean;
import org.mapton.api.MSimpleObjectStorageString;
import org.openide.util.NbPreferences;

public class MSimpleObjectStorageManager {
    private final ConcurrentHashMap<Class, Preferences> mClassToPreferenceNode = new ConcurrentHashMap();
    private final Preferences mPreferences = NbPreferences.forModule(MSimpleObjectStorageManager.class).node("simple_object_storage");

    public static MSimpleObjectStorageManager getInstance() {
        return Holder.INSTANCE;
    }

    private MSimpleObjectStorageManager() {
    }

    public void addListener(PreferenceChangeListener pcl, Class<? extends MSimpleObjectStorage> clazz) {
        String category = MSimpleObjectStorageBoolean.class.isAssignableFrom(clazz) ? "boolean" : "string";
        this.getNode(category, clazz).addPreferenceChangeListener(pcl);
    }

    public void addListeners(PreferenceChangeListener pcl, Class<? extends MSimpleObjectStorage> ... clazzes) {
        for (Class<? extends MSimpleObjectStorage> clazz : clazzes) {
            this.addListener(pcl, clazz);
        }
    }

    public Boolean getBoolean(Class c, Boolean defaultValue) {
        return this.getNode("boolean", c).getBoolean(c.getName(), defaultValue);
    }

    public File getFile(Class c, File defaultValue) {
        return new File(this.getString(c, defaultValue.getAbsolutePath()));
    }

    public String getString(Class c, String defaultValue) {
        return this.getNode("string", c).get(c.getName(), defaultValue);
    }

    public void putBoolean(Class<? extends MSimpleObjectStorageBoolean> c, Boolean value) {
        this.getNode("boolean", c).putBoolean(c.getName(), value);
    }

    public void putString(Class<? extends MSimpleObjectStorageString> c, String value) {
        this.getNode("string", c).put(c.getName(), StringUtils.defaultString((String)value));
    }

    private Preferences getNode(String category, Class c) {
        Preferences parentNode = this.mPreferences.node(category);
        if (MSimpleObjectStorageString.ApiKey.class.isAssignableFrom(c)) {
            return this.mClassToPreferenceNode.computeIfAbsent(MSimpleObjectStorageString.ApiKey.class, k -> parentNode.node("api_key"));
        }
        if (MSimpleObjectStorageString.Path.class.isAssignableFrom(c)) {
            return this.mClassToPreferenceNode.computeIfAbsent(MSimpleObjectStorageString.Path.class, k -> parentNode.node("path"));
        }
        if (MSimpleObjectStorageString.Url.class.isAssignableFrom(c)) {
            return this.mClassToPreferenceNode.computeIfAbsent(MSimpleObjectStorageString.Url.class, k -> parentNode.node("url"));
        }
        if (MSimpleObjectStorageString.Misc.class.isAssignableFrom(c)) {
            return this.mClassToPreferenceNode.computeIfAbsent(MSimpleObjectStorageString.Misc.class, k -> parentNode.node("misc"));
        }
        if (MSimpleObjectStorageBoolean.AutoOpen.class.isAssignableFrom(c)) {
            return this.mClassToPreferenceNode.computeIfAbsent(MSimpleObjectStorageBoolean.AutoOpen.class, k -> parentNode.node("autoOpen"));
        }
        if (MSimpleObjectStorageBoolean.UpdaterAutoUpdate.class.isAssignableFrom(c)) {
            return this.mClassToPreferenceNode.computeIfAbsent(MSimpleObjectStorageBoolean.UpdaterAutoUpdate.class, k -> parentNode.node("updaterAutoUpdate"));
        }
        return parentNode.node("unknown");
    }

    private static class Holder {
        private static final MSimpleObjectStorageManager INSTANCE = new MSimpleObjectStorageManager();

        private Holder() {
        }
    }
}

