/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javafx.beans.property.SimpleObjectProperty;
import org.apache.commons.lang3.StringUtils;
import org.mapton.api.MTemporalRange;
import se.trixon.almond.util.fx.DelayedResetRunner;
import se.trixon.almond.util.fx.control.DateSelectionMode;

public class MTemporalManager {
    private final SimpleObjectProperty<DateSelectionMode> mDateSelectionModeProperty = new SimpleObjectProperty();
    private final DelayedResetRunner mDelayedResetRunner;
    private final SimpleObjectProperty<LocalDate> mHighDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mLowDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mMaxDateProperty = new SimpleObjectProperty();
    private final SimpleObjectProperty<LocalDate> mMinDateProperty = new SimpleObjectProperty();
    private final ConcurrentHashMap<String, MTemporalRange> mRanges = new ConcurrentHashMap();

    public static MTemporalManager getInstance() {
        return Holder.INSTANCE;
    }

    private MTemporalManager() {
        this.mDelayedResetRunner = new DelayedResetRunner(100, () -> {
            TreeSet<MTemporalRange> fromRanges = new TreeSet<MTemporalRange>(Comparator.comparing(MTemporalRange::getFromLocalDate));
            TreeSet<MTemporalRange> toRanges = new TreeSet<MTemporalRange>(Comparator.comparing(MTemporalRange::getToLocalDate));
            for (MTemporalRange range : this.mRanges.values()) {
                fromRanges.add(range);
                toRanges.add(range);
            }
            if (!fromRanges.isEmpty() && !toRanges.isEmpty()) {
                this.setMinDate(fromRanges.first().getFromLocalDate());
                this.setMaxDate(toRanges.last().getToLocalDate());
            } else {
                this.setMinDate(LocalDate.of(1900, 1, 1));
                this.setMaxDate(LocalDate.of(2099, 12, 31));
            }
        });
    }

    public void clear() {
        this.mRanges.clear();
        this.refresh();
    }

    public boolean contains(String key) {
        return this.mRanges.containsKey(key);
    }

    public SimpleObjectProperty<DateSelectionMode> dateSelectionModeProperty() {
        return this.mDateSelectionModeProperty;
    }

    public synchronized ConcurrentHashMap<String, MTemporalRange> getAndRemoveSubSet(String prefix) {
        ConcurrentHashMap<String, MTemporalRange> subSet = this.getSubSet(prefix);
        this.removeAll(prefix);
        return subSet;
    }

    public DateSelectionMode getDateSelectionMode() {
        return (DateSelectionMode)((Object)this.mDateSelectionModeProperty.getValue());
    }

    public LocalDate getHighDate() {
        return (LocalDate)this.mHighDateProperty.getValue();
    }

    public LocalDate getLowDate() {
        return (LocalDate)this.mLowDateProperty.getValue();
    }

    public LocalDate getMaxDate() {
        return (LocalDate)this.mMaxDateProperty.getValue();
    }

    public LocalDate getMinDate() {
        return (LocalDate)this.mMinDateProperty.getValue();
    }

    public synchronized ConcurrentHashMap<String, MTemporalRange> getSubSet(String prefix) {
        ConcurrentHashMap<String, MTemporalRange> subSet = new ConcurrentHashMap<String, MTemporalRange>();
        for (String key : this.mRanges.keySet()) {
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) continue;
            subSet.put(key, this.mRanges.get(key));
        }
        return subSet;
    }

    public SimpleObjectProperty<LocalDate> highDateProperty() {
        return this.mHighDateProperty;
    }

    public synchronized boolean isValid(String string) {
        return this.isValid(LocalDate.parse(string));
    }

    public synchronized boolean isValid(LocalDate localDate) {
        return this.getLowDate().compareTo(localDate) * localDate.compareTo(this.getHighDate()) >= 0;
    }

    public synchronized boolean isValid(LocalDateTime localDateTime) {
        return this.isValid(localDateTime.toLocalDate());
    }

    public synchronized boolean isValid(Timestamp timestamp) {
        return this.isValid(timestamp.toLocalDateTime().toLocalDate());
    }

    public synchronized boolean isValid(java.sql.Date date) {
        return this.isValid(date.toLocalDate());
    }

    public synchronized boolean isValid(Date date) {
        return this.isValid(date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
    }

    public SimpleObjectProperty<LocalDate> lowDateProperty() {
        return this.mLowDateProperty;
    }

    public SimpleObjectProperty<LocalDate> maxDateProperty() {
        return this.mMaxDateProperty;
    }

    public SimpleObjectProperty<LocalDate> minDateProperty() {
        return this.mMinDateProperty;
    }

    public synchronized void put(String key, MTemporalRange range) {
        this.mRanges.put(key, range);
    }

    public synchronized void putAll(ConcurrentHashMap<String, MTemporalRange> subSet) {
        this.mRanges.putAll(subSet);
        this.refresh();
    }

    public void refresh() {
        this.mDelayedResetRunner.reset();
    }

    public synchronized MTemporalRange remove(String key) {
        return this.mRanges.remove(key);
    }

    public synchronized void removeAll(String prefix) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.mRanges.keySet()) {
            if (!StringUtils.startsWith((CharSequence)key, (CharSequence)prefix)) continue;
            keys.add(key);
        }
        for (String key : keys) {
            this.mRanges.remove(key);
        }
        this.refresh();
    }

    public void setDateSelectionMode(DateSelectionMode dateSelectionMode) {
        this.mDateSelectionModeProperty.setValue((Object)dateSelectionMode);
    }

    public void setHighDate(LocalDate localDate) {
        this.mHighDateProperty.setValue((Object)localDate);
    }

    public void setLowDate(LocalDate localDate) {
        this.mLowDateProperty.setValue((Object)localDate);
    }

    public void setMaxDate(LocalDate localDate) {
        this.mMaxDateProperty.setValue((Object)localDate);
    }

    public void setMinDate(LocalDate localDate) {
        this.mMinDateProperty.setValue((Object)localDate);
    }

    private static class Holder {
        private static final MTemporalManager INSTANCE = new MTemporalManager();

        private Holder() {
        }
    }
}

