/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import java.awt.event.ActionListener;
import java.io.File;
import java.util.Date;
import javafx.util.Duration;
import javax.swing.Timer;
import org.apache.commons.lang3.time.FastDateFormat;
import org.mapton.api.MPrint;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;

public abstract class MUpdater {
    public static final Duration FREQ_10_MINUTES = Duration.minutes((double)10.0);
    public static final Duration FREQ_1_MINUTE = Duration.minutes((double)1.0);
    public static final Duration FREQ_1_WEEK = Duration.hours((double)168.0);
    public static final Duration FREQ_2_HOURS = Duration.hours((double)2.0);
    public static final Duration FREQ_2_MINUTES = Duration.minutes((double)2.0);
    public static final Duration FREQ_2_WEEKS = Duration.hours((double)336.0);
    public static final Duration FREQ_30_MINUTES = Duration.minutes((double)30.0);
    protected MPrint mPrint = new MPrint("updater.logger");
    protected Timer mTimer;
    private Long mAgeLimit;
    private boolean mAutoUpdate;
    private Duration mAutoUpdateInterval;
    private Runnable mAutoUpdatePostRunnable;
    private String mCategory = null;
    private String mComment;
    private boolean mMarkedForUpdate;
    private String mName;
    private Runnable mRunnable;

    public Long getAgeLimit() {
        return this.mAgeLimit;
    }

    public Duration getAutoUpdateInterval() {
        return this.mAutoUpdateInterval;
    }

    public Runnable getAutoUpdatePostRunnable() {
        return this.mAutoUpdatePostRunnable;
    }

    public String getCategory() {
        return this.mCategory;
    }

    public String getComment() {
        return this.mComment;
    }

    public abstract String getLastUpdated();

    public String getName() {
        return this.mName;
    }

    public MPrint getPrint() {
        return this.mPrint;
    }

    public Runnable getRunnable() {
        return this.mRunnable;
    }

    public boolean isAutoUpdate() {
        return this.mAutoUpdate;
    }

    public boolean isAutoUpdateEnabled() {
        return true;
    }

    public boolean isMarkedForUpdate() {
        return this.mMarkedForUpdate;
    }

    public abstract boolean isOutOfDate();

    public void run() {
        this.mRunnable.run();
    }

    public void setAgeLimit(Long ageLimit) {
        this.mAgeLimit = ageLimit;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.mAutoUpdate = autoUpdate;
    }

    public void setAutoUpdateInterval(Duration autoUpdateInterval) {
        this.mAutoUpdateInterval = autoUpdateInterval;
        this.setAgeLimit(Math.round(this.mAutoUpdateInterval.toMillis()));
    }

    public void setAutoUpdatePostRunnable(Runnable autoUpdatePostRunnable) {
        this.mAutoUpdatePostRunnable = autoUpdatePostRunnable;
    }

    public void setCategory(String category) {
        this.mCategory = category;
    }

    public void setComment(String comment) {
        this.mComment = comment;
    }

    public void setMarkedForUpdate(boolean markedForUpdate) {
        this.mMarkedForUpdate = markedForUpdate;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setPrint(MPrint print) {
        this.mPrint = print;
    }

    public void setRunnable(Runnable runnable) {
        this.mRunnable = runnable;
    }

    public static abstract class ByFile
    extends MUpdater {
        private File mFile;

        public File getFile() {
            return this.mFile;
        }

        @Override
        public String getLastUpdated() {
            String lastUpdate = "-";
            if (this.mFile != null && this.mFile.isFile()) {
                lastUpdate = FastDateFormat.getInstance((String)"yyyy-MM-dd HH.mm.ss").format(new Date(this.mFile.lastModified()));
            }
            return Dict.UPDATED_S.toString().formatted(lastUpdate);
        }

        public void initAutoUpdater() {
            int defaultDelay = (int)this.getAutoUpdateInterval().toMillis();
            ActionListener actionListener = actionEvent -> new Thread(() -> {
                if (this.isAutoUpdateEnabled()) {
                    this.mPrint.out("%s %s/%s".formatted("AutoUpdate", this.getCategory(), this.getName()));
                    this.getRunnable().run();
                    this.mPrint.out("%s %s/%s, %s".formatted("AutoUpdate", this.getCategory(), this.getName(), Dict.DONE.toString().toLowerCase()));
                    this.mTimer.setDelay(defaultDelay);
                    this.mTimer.setInitialDelay(defaultDelay);
                    this.mTimer.restart();
                    if (this.getAutoUpdatePostRunnable() != null) {
                        this.getAutoUpdatePostRunnable().run();
                    }
                } else {
                    this.mTimer.setDelay(defaultDelay);
                    this.mTimer.setInitialDelay(defaultDelay);
                    this.mTimer.restart();
                }
            }, this.getClass().getCanonicalName()).start();
            this.mTimer = new Timer(defaultDelay, actionListener);
            if (!this.mFile.exists() || SystemHelper.age(this.mFile.lastModified()) > (long)defaultDelay) {
                actionListener.actionPerformed(null);
            } else {
                long initialDelay = defaultDelay;
                if (this.mFile.exists()) {
                    initialDelay = this.mFile.lastModified() + (long)defaultDelay - System.currentTimeMillis();
                }
                int actualDelay = (int)Math.max(0L, initialDelay);
                this.mTimer.setDelay(actualDelay);
                this.mTimer.setInitialDelay(actualDelay);
                this.mTimer.start();
            }
        }

        @Override
        public boolean isOutOfDate() {
            return this.mFile != null && (!this.mFile.exists() || SystemHelper.age(this.mFile.lastModified()) >= this.getAgeLimit());
        }

        public void setFile(File file) {
            this.mFile = file;
        }
    }
}

