/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.text.DateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.util.Duration;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.action.Action;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.mapton.api.MEngine;
import org.mapton.api.MOptions;
import org.mapton.api.MReplacer;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.Places;
import org.openide.util.Lookup;
import se.trixon.almond.util.ExecutionFlow;
import se.trixon.almond.util.GlobalState;
import se.trixon.almond.util.Log;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.swing.SwingHelper;

public class Mapton {
    public static final int ICON_SIZE_MODULE = 32;
    public static final int ICON_SIZE_MODULE_TOOLBAR = 40;
    public static final int ICON_SIZE_PROFILE = 32;
    public static final int ICON_SIZE_TOOLBAR = 32;
    public static final int ICON_SIZE_DRAWER = 16;
    public static final String LOG_TAG = "Mapton";
    public static final int MODULE_ICON_SIZE = 32;
    public static final double MYLAT = 57.66;
    public static final double MYLON = 12.0;
    private static File CACHE_DIR;
    private static File CONFIG_DIR;
    private static final ExecutionFlow EXECUTION_FLOW;
    private static final Color ICON_COLOR;
    private static final MEngine NOOP_ENGINE;
    private static final HashMap<WebEngine, String> WEB_ENGINE_TO_STYLE;
    private static final GlobalState sGlobalState;
    private static final Gson sGson;
    private static final Log sLog;
    private final DoubleProperty mZoomProperty = new SimpleDoubleProperty();

    public static void applyHtmlCss(WebView webView, String filename) {
        WEB_ENGINE_TO_STYLE.put(webView.getEngine(), filename);
        Mapton.applyHtmlCss(webView.getEngine(), filename);
        webView.setZoom(SwingHelper.getUIScale());
    }

    public static void applyHtmlCss(WebEngine webEngine, String filename) {
        String path = "resources/css/%s".formatted(filename);
        String codeNameBase = Mapton.class.getPackage().getName();
        File file = InstalledFileLocator.getDefault().locate(path, codeNameBase, false);
        if (Mapton.isNightMode()) {
            path = StringUtils.replace((String)path, (String)".css", (String)"_dark.css");
            File darkFile = InstalledFileLocator.getDefault().locate(path, codeNameBase, false);
            file = darkFile.isFile() ? darkFile : file;
        }
        webEngine.setUserStyleSheetLocation(file.toURI().toString());
    }

    public static void clearBackgroundImage() {
        Mapton.getGlobalState().put("background_image", null);
    }

    public static Glyph createGlyph(FontAwesome.Glyph glyphFont, double size, Color color) {
        return new Glyph("FontAwesome", (Object)glyphFont).size(size).color(color);
    }

    public static Glyph createGlyphToolbarForm(FontAwesome.Glyph glyphFont) {
        return Mapton.createGlyph(glyphFont, Mapton.getIconSizeToolBarInt(), Mapton.options().getIconColorForBackground());
    }

    public static Label createTitle(String title) {
        return Mapton.createTitle(title, Mapton.getDefaultThemeBackground());
    }

    public static Label createTitle(String title, Background background) {
        Label label = new Label(title);
        label.setBackground(background);
        Color color = (Color)((BackgroundFill)background.getFills().get(0)).getFill();
        label.setStyle("-fx-background-color: %s;".formatted(FxHelper.colorToString(color)));
        label.setAlignment(Pos.BASELINE_CENTER);
        label.setFont(new Font(FxHelper.getScaledFontSize() * 0.9));
        label.setTextFill((Paint)Color.WHITE);
        return label;
    }

    public static Label createTitleDev(String title) {
        return Mapton.createTitle(title + "-dev", FxHelper.createBackground(Color.RED));
    }

    public static void execute(Runnable runnable) {
        if (Mapton.getEngine().isSwing()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static File getCacheDir() {
        if (CACHE_DIR == null) {
            CACHE_DIR = Places.getCacheDirectory();
        }
        return CACHE_DIR;
    }

    public static File getConfigDir() {
        if (CONFIG_DIR == null) {
            CONFIG_DIR = new File(Places.getUserDirectory(), "mapton-modules");
        }
        return CONFIG_DIR;
    }

    public static DateFormat getDefaultDateFormat() {
        return DateFormat.getDateTimeInstance(3, 2);
    }

    public static Background getDefaultThemeBackground() {
        return FxHelper.createBackground(Mapton.getDefaultThemeColor());
    }

    public static Color getDefaultThemeColor() {
        return Color.web((String)"#102039");
    }

    public static Color getDefaultThemeForegroundColor() {
        return Color.WHITE;
    }

    public static synchronized MEngine getEngine() {
        for (MEngine mapEngine : Lookup.getDefault().lookupAll(MEngine.class)) {
            try {
                if (!StringUtils.equalsIgnoreCase((CharSequence)mapEngine.getName(), (CharSequence)Mapton.options().getEngine())) continue;
                return mapEngine;
            }
            catch (Exception exception) {
            }
        }
        return NOOP_ENGINE;
    }

    public static ExecutionFlow getExecutionFlow() {
        return EXECUTION_FLOW;
    }

    public static GlobalState getGlobalState() {
        return sGlobalState;
    }

    public static Gson getGson() {
        return sGson;
    }

    public static Color getIconColor() {
        return ICON_COLOR;
    }

    public static int getIconSizeContextMenu() {
        return (int)((double)Mapton.getIconSizeToolBar() / 2.0);
    }

    public static int getIconSizeToolBar() {
        return SwingHelper.getUIScaled(32);
    }

    public static int getIconSizeToolBarInt() {
        return (int)((double)Mapton.getIconSizeToolBar() / 1.3);
    }

    public static Mapton getInstance() {
        return Holder.INSTANCE;
    }

    public static Log getLog() {
        return sLog;
    }

    public static Background getThemeBackground() {
        return FxHelper.createBackground(Mapton.getThemeColor());
    }

    public static Color getThemeColor() {
        return (Color)Mapton.getGlobalState().getOrDefault("app_theme_background", Mapton.getDefaultThemeColor());
    }

    public static Color getThemeForegroundColor() {
        return (Color)Mapton.getGlobalState().getOrDefault("app_theme_foreground", Mapton.getDefaultThemeForegroundColor());
    }

    public static boolean isNightMode() {
        return Mapton.options().isNightMode();
    }

    public static void log(String line) {
        sLog.timedOut(line);
    }

    public static void log(String category, String item) {
        sLog.timedOut("%s: %s ".formatted(category, item));
    }

    public static void logDownloading(String category, String item) {
        sLog.timedOut("Downloading %s: %s ".formatted(category, item));
    }

    public static void logLoading(String category, String item) {
        sLog.timedOut("Loading %s: %s ".formatted(category, item));
    }

    public static void logRemoving(String category, String item) {
        sLog.timedOut("Removing %s: %s ".formatted(category, item));
    }

    public static void notification(String type, String title, String text) {
        Mapton.getGlobalState().send(type, Notifications.create().title(title).text(text));
    }

    public static void notification(String type, String title, String text, Action ... actions) {
        Notifications notifications = Notifications.create().title(title).text(text).hideAfter(Duration.INDEFINITE).action(actions);
        Mapton.getGlobalState().send(type, notifications);
    }

    public static void notification(String type, String title, String text, Duration hideDuration, Action ... actions) {
        Notifications notifications = Notifications.create().title(title).text(text).hideAfter(hideDuration).action(actions);
        Mapton.getGlobalState().send(type, notifications);
    }

    public static MOptions options() {
        return MOptions.getInstance();
    }

    public static String replaceSubstring(String s) {
        if (StringUtils.contains((CharSequence)s, (CharSequence)":::REPLACEME:::")) {
            s = StringUtils.remove((String)s, (String)":::REPLACEME");
            String id = StringUtils.substringBetween((String)s, (String)":::");
            Optional<MReplacer> replacer = Lookup.getDefault().lookupAll(MReplacer.class).stream().filter(m -> m.getKey().equalsIgnoreCase(id)).findFirst();
            if (replacer.isEmpty()) {
                return s;
            }
            String replacement = replacer.get().getValue();
            s = StringUtils.replace((String)s, (String)(":::" + id + ":::"), (String)replacement);
            return s;
        }
        return s;
    }

    protected Mapton() {
        Platform.runLater(() -> Mapton.options().nightModeProperty().addListener((observable, oldValue, newValue) -> {
            for (Map.Entry<WebEngine, String> entry : WEB_ENGINE_TO_STYLE.entrySet()) {
                Mapton.applyHtmlCss(entry.getKey(), entry.getValue());
            }
        }));
    }

    public DoubleProperty zoomProperty() {
        return this.mZoomProperty;
    }

    static {
        EXECUTION_FLOW = new ExecutionFlow();
        ICON_COLOR = Color.BLACK;
        WEB_ENGINE_TO_STYLE = new HashMap();
        sGlobalState = new GlobalState();
        sGson = new GsonBuilder().setVersion(1.0).serializeNulls().setPrettyPrinting().create();
        sLog = new Log();
        NOOP_ENGINE = new MEngine(){

            @Override
            public void create(Runnable postCreateRunnable) {
                throw new UnsupportedOperationException("No engine found");
            }

            @Override
            public JComponent getMapComponent() {
                throw new UnsupportedOperationException("No engine found");
            }

            @Override
            public Node getMapNode() {
                throw new UnsupportedOperationException("No engine found");
            }

            @Override
            public String getName() {
                throw new UnsupportedOperationException("No engine found");
            }

            @Override
            public Node getStyleView() {
                throw new UnsupportedOperationException("No engine found");
            }
        };
    }

    private static class Holder {
        private static final Mapton INSTANCE = new Mapton();

        private Holder() {
        }
    }
}

