/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.db;

import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.healthmarketscience.sqlbuilder.custom.mysql.MysObjects;
import com.healthmarketscience.sqlbuilder.dbspec.Table;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbColumn;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbConstraint;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbSpec;
import com.healthmarketscience.sqlbuilder.dbspec.basic.DbTable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.openide.modules.Places;

public class Db {
    private static final String DB_POSTFIX = ".mv.db";
    private static final Logger LOGGER = Logger.getLogger(Db.class.getName());
    private Connection mAutoCommitConnection = null;
    private final String mConnString;
    private final File mDbFile = new File(Places.getUserDirectory(), "mapton_02.mv.db");
    private final DbSpec mSpec;

    public static Db getInstance() {
        return Holder.INSTANCE;
    }

    private Db() {
        this.mConnString = "jdbc:h2:%s;DEFRAG_ALWAYS=true".formatted(StringUtils.removeEnd((String)this.mDbFile.getAbsolutePath(), (String)DB_POSTFIX));
        this.mSpec = new DbSpec();
        this.init();
    }

    public void addMissingColumn(String table, String col, String type, String after) throws SQLException {
        try (Statement statement = this.getAutoCommitConnection().createStatement(1004, 1008);){
            String sql = "ALTER TABLE IF EXISTS %s ADD COLUMN IF NOT EXISTS %s %s AFTER %s;".formatted(table, col, type, after);
            statement.execute(sql);
        }
    }

    public boolean create(DbTable table, boolean replace, DbConstraint ... constraints) {
        boolean tableCreated;
        try (Statement statement = this.getAutoCommitConnection().createStatement(1004, 1008);){
            if (table.getConstraints().isEmpty()) {
                for (DbConstraint constraint : constraints) {
                    table.addConstraint(constraint);
                }
            }
            CreateTableQuery createTableQuery = new CreateTableQuery((Table)table, true);
            if (!replace) {
                createTableQuery.addCustomization(MysObjects.IF_NOT_EXISTS_TABLE);
            }
            String sql = ((CreateTableQuery)createTableQuery.validate()).toString();
            tableCreated = statement.execute(sql);
        }
        catch (SQLException ex) {
            LOGGER.log(Level.SEVERE, "Table creation failed. {0}", table.getName());
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
            tableCreated = false;
        }
        return tableCreated;
    }

    public void delete(DbTable table, DbColumn column, Long id) throws ClassNotFoundException, SQLException {
        try (Statement statement = this.getAutoCommitConnection().createStatement(1004, 1008);){
            String sql = "DELETE FROM %s WHERE %s=%d;".formatted(table.getName(), column.getName(), id);
            System.out.println(sql);
            statement.execute(sql);
        }
    }

    public void drop(DbTable table, boolean cascade) throws ClassNotFoundException, SQLException {
        try (Statement statement = this.getAutoCommitConnection().createStatement(1004, 1008);){
            String sql = "DROP TABLE IF EXISTS %s %s;".formatted(table.getName(), cascade ? "CASCADE" : "");
            statement.execute(sql);
        }
    }

    public void dropAllObjects() throws ClassNotFoundException, SQLException {
        try (Statement statement = this.getAutoCommitConnection().createStatement(1004, 1008);){
            String sql = "DROP ALL OBJECTS;";
            System.out.println(sql);
            statement.execute(sql);
        }
    }

    public Connection getAutoCommitConnection() {
        try {
            if (this.mAutoCommitConnection == null || this.mAutoCommitConnection.isClosed()) {
                Class.forName("org.h2.Driver");
                this.mAutoCommitConnection = DriverManager.getConnection(this.mConnString);
            } else if (!this.mAutoCommitConnection.isValid(2)) {
                this.mAutoCommitConnection = null;
                LOGGER.severe("Database connection lost");
            }
        }
        catch (ClassNotFoundException | SQLException ex) {
            LOGGER.severe("Database may be already in use: Possible solutions: close all other connection(s); use the server mode [90020-196]");
        }
        return this.mAutoCommitConnection;
    }

    public File getDbFile() {
        return this.mDbFile;
    }

    public DbSpec getSpec() {
        return this.mSpec;
    }

    public void truncate(DbTable table) throws ClassNotFoundException, SQLException {
        try (Statement statement = this.getAutoCommitConnection().createStatement(1004, 1008);){
            String sql = "TRUNCATE TABLE %s;".formatted(table.getName());
            statement.execute(sql);
        }
    }

    private void init() {
        this.mSpec.addDefaultSchema();
    }

    private static class Holder {
        private static final Db INSTANCE = new Db();

        private Holder() {
        }
    }
}

