/*
 * Decompiled with CFR 0.152.
 */
package org.mapton.api.ui;

import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.web.WebView;
import org.mapton.api.Mapton;
import org.mapton.api.ui.MPopOver;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.html.HTMLAnchorElement;
import se.trixon.almond.util.Dict;
import se.trixon.almond.util.SystemHelper;
import se.trixon.almond.util.fx.FxHelper;
import se.trixon.almond.util.icons.material.MaterialIcon;

public abstract class MInfoPopOver
extends MPopOver {
    private WebView mWebView;

    public MInfoPopOver() {
        this.createUI();
        this.initListeners();
        this.setTitle(Dict.INFORMATION.toString());
        this.getAction().setGraphic((Node)MaterialIcon._Action.INFO_OUTLINE.getImageView(Mapton.getIconSizeToolBarInt()));
    }

    public void load(String url) {
        this.mWebView.getEngine().load(url);
    }

    public void loadContent(String content) {
        this.mWebView.getEngine().loadContent(content);
    }

    private void createUI() {
        this.mWebView = new WebView();
        this.mWebView.setPrefSize((double)FxHelper.getUIScaled(500), (double)FxHelper.getUIScaled(300));
        Mapton.applyHtmlCss(this.mWebView, "info.css");
        this.setContentNode((Node)this.mWebView);
    }

    private void initListeners() {
        this.mWebView.getEngine().getLoadWorker().stateProperty().addListener((ov, t, t1) -> {
            if (t1 == Worker.State.SUCCEEDED) {
                NodeList domNodeList = this.mWebView.getEngine().getDocument().getElementsByTagName("a");
                for (int i = 0; i < domNodeList.getLength(); ++i) {
                    org.w3c.dom.Node domNode = domNodeList.item(i);
                    EventTarget domEventTarget = (EventTarget)((Object)domNode);
                    domEventTarget.addEventListener("click", domEvent -> {
                        EventTarget domCurrentTarget = domEvent.getCurrentTarget();
                        HTMLAnchorElement domHtmlAnchorElement = (HTMLAnchorElement)((Object)domCurrentTarget);
                        String href = domHtmlAnchorElement.getHref();
                        this.hide();
                        SystemHelper.desktopBrowse(href);
                        domEvent.preventDefault();
                    }, false);
                }
            }
        });
    }
}

