/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.directions;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.javascript.object.LatLong;
import com.dlsc.gmapsfx.service.directions.Distance;
import com.dlsc.gmapsfx.service.directions.Duration;
import com.dlsc.gmapsfx.service.directions.TravelModes;
import com.dlsc.gmapsfx.service.geocoding.GeocoderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSObject;

public class DirectionsSteps
extends JavascriptObject {
    public DirectionsSteps() {
        super("google.maps.DirectionsStep");
    }

    public DirectionsSteps(JSObject jsObject) {
        super("google.maps.DirectionsStep", jsObject);
    }

    public String getInstructions() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("instructions");
            return location.toString();
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public Distance getDistance() {
        try {
            JSObject distance = (JSObject)this.getJSObject().getMember("distance");
            return new Distance(distance);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public Duration getDuration() {
        try {
            JSObject duration = (JSObject)this.getJSObject().getMember("duration");
            return new Duration(duration);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public LatLong getStartLocation() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("start_location");
            return new LatLong(location);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public LatLong getEndLocation() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("end_location");
            return new LatLong(location);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public List<DirectionsSteps> getSteps() {
        ArrayList<DirectionsSteps> result = new ArrayList<DirectionsSteps>();
        List<JSObject> jsLocalities = GeocoderUtils.getJSObjectsFromArray((JSObject)this.getJSObject().getMember("postcode_localities"));
        for (JSObject jsLocality : jsLocalities) {
            DirectionsSteps ll = new DirectionsSteps(jsLocality);
            if (jsLocality.toString().equals("undefined")) continue;
            result.add(ll);
        }
        return result;
    }

    public TravelModes getTravelMode() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("travel_mode");
            switch (location.toString()) {
                case "DRIVING": {
                    return TravelModes.DRIVING;
                }
                case "BICYCLING": {
                    return TravelModes.BICYCLING;
                }
                case "TRANSIT": {
                    return TravelModes.TRANSIT;
                }
                case "WALKING": {
                    return TravelModes.WALKING;
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
        }
        return null;
    }

    public List<LatLong> getPath() {
        ArrayList<LatLong> result = new ArrayList<LatLong>();
        List<JSObject> jsLocalities = GeocoderUtils.getJSObjectsFromArray((JSObject)this.getJSObject().getMember("path"));
        for (JSObject jsLocality : jsLocalities) {
            LatLong ll = new LatLong(jsLocality);
            if (jsLocality.toString().equals("undefined")) continue;
            result.add(ll);
        }
        return result;
    }
}

