/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.elevation;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.service.elevation.ElevationResult;
import com.dlsc.gmapsfx.service.elevation.ElevationServiceCallback;
import com.dlsc.gmapsfx.service.elevation.ElevationStatus;
import com.dlsc.gmapsfx.service.elevation.LocationElevationRequest;
import com.dlsc.gmapsfx.service.elevation.PathElevationRequest;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElevationService
extends JavascriptObject {
    private static final Logger LOG = LoggerFactory.getLogger(ElevationService.class);
    private ElevationServiceCallback callback;

    public ElevationService() {
        super("google.maps.ElevationService");
    }

    public void getElevationForLocations(LocationElevationRequest req, ElevationServiceCallback callback) {
        this.callback = callback;
        JSObject doc = (JSObject)this.getJSObject().eval("document");
        doc.setMember(this.getVariableName(), this);
        StringBuilder r = new StringBuilder(this.getVariableName()).append(".").append("getElevationForLocations(").append(req.getVariableName()).append(", ").append("function(results, status) {alert('rec:'+status);\ndocument.").append(this.getVariableName()).append(".processResponse(results, status);});");
        LOG.trace("ElevationService direct call: " + r.toString());
        this.getJSObject().eval(r.toString());
    }

    public void getElevationAlongPath(PathElevationRequest req, ElevationServiceCallback callback) {
        this.callback = callback;
        JSObject doc = (JSObject)this.getJSObject().eval("document");
        doc.setMember(this.getVariableName(), this);
        StringBuilder r = new StringBuilder(this.getVariableName()).append(".").append("getElevationAlongPath(").append(req.getVariableName()).append(", ").append("function(results, status) {document.").append(this.getVariableName()).append(".processResponse(results, status);});");
        this.getJSObject().eval(r.toString());
    }

    public void processResponse(Object results, Object status) {
        JSObject jsres;
        Object len;
        ElevationStatus pStatus = ElevationStatus.UNKNOWN_ERROR;
        if (status instanceof String && results instanceof JSObject && ElevationStatus.OK.equals((Object)(pStatus = ElevationStatus.valueOf((String)status))) && (len = (jsres = (JSObject)results).getMember("length")) instanceof Number) {
            int n = ((Number)len).intValue();
            ElevationResult[] ers = new ElevationResult[n];
            for (int i = 0; i < n; ++i) {
                Object obj = jsres.getSlot(i);
                if (!(obj instanceof JSObject)) continue;
                ers[i] = new ElevationResult((JSObject)obj);
            }
            this.callback.elevationsReceived(ers, pStatus);
            return;
        }
        this.callback.elevationsReceived(new ElevationResult[0], pStatus);
    }
}

