/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gmapsfx.service.geocoding;

import com.dlsc.gmapsfx.javascript.JavascriptObject;
import com.dlsc.gmapsfx.javascript.object.LatLong;
import com.dlsc.gmapsfx.javascript.object.LatLongBounds;
import com.dlsc.gmapsfx.service.geocoding.GeocoderLocationType;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.javascript.JSObject;

public class GeocoderGeometry
extends JavascriptObject {
    public GeocoderGeometry() {
        super("google.maps.GeocoderGeometry");
    }

    public GeocoderGeometry(JSObject jsObject) {
        super("google.maps.GeocoderGeometry", jsObject);
    }

    public LatLong getLocation() {
        try {
            JSObject location = (JSObject)this.getJSObject().getMember("location");
            return new LatLong(location);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public GeocoderLocationType getLocationType() {
        try {
            String locationType = this.getJSObject().getMember("location_type").toString();
            return GeocoderLocationType.valueOf(locationType.toUpperCase());
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public LatLongBounds getViewPort() {
        try {
            JSObject viewPort = (JSObject)this.getJSObject().getMember("viewport");
            return new LatLongBounds(viewPort);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public LatLongBounds getBounds() {
        try {
            JSObject bounds = (JSObject)this.getJSObject().getMember("bounds");
            return new LatLongBounds(bounds);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "", e);
            return null;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("\t Location: ").append(this.getLocation()).append("\n");
        builder.append("\t Location Type: ").append((Object)this.getLocationType()).append("\n");
        builder.append("\t View Port: ").append(this.getViewPort()).append("\n");
        builder.append("\t Bounds: ").append(this.getBounds()).append("\n");
        return builder.toString();
    }
}

